/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * トリガー情報クラス。<br />
 * このクラスはトリガー情報を格納します。
 */
@XStreamAlias("TriggerSet")
public class TriggerSet {

    /** リソース */
    private String resource;

    /** 条件「以上」の閾値 */
    private Double upperThreshold;

    /** 長さ（秒） */
    private Integer breachDuration;

    /**
     * リソースを取得します。
     * 
     * @return リソース
     */
    public String getResource() {
        return resource;
    }

    /**
     * リソースを設定します。
     * 
     * @param resource
     *            リソース
     */
    public void setResource(String resource) {
        this.resource = resource;
    }

    /**
     * リソースを設定し、自オブジェクトを返します。
     * 
     * @param resource
     *            リソース
     * @return 自オブジェクト
     */
    public TriggerSet withResource(String resource) {
        setResource(resource);
        return this;
    }

    /**
     * 条件「以上」の閾値を取得します。
     * 
     * @return 条件「以上」の閾値
     */
    public Double getUpperThreshold() {
        return upperThreshold;
    }

    /**
     * 条件「以上」の閾値を設定します。
     * 
     * @param upperThreshold
     *            条件「以上」の閾値
     */
    public void setUpperThreshold(Double upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    /**
     * 条件「以上」の閾値を設定し、自オブジェクトを返します。
     * 
     * @param upperThreshold
     *            条件「以上」の閾値
     * @return 自オブジェクト
     */
    public TriggerSet withUpperThreshold(Double upperThreshold) {
        setUpperThreshold(upperThreshold);
        return this;
    }

    /**
     * 長さ（秒）を取得します。
     * 
     * @return 長さ（秒）
     */
    public Integer getBreachDuration() {
        return breachDuration;
    }

    /**
     * 長さ（秒）を設定します。
     * 
     * @param breachDuration
     *            長さ（秒）
     */
    public void setBreachDuration(Integer breachDuration) {
        this.breachDuration = breachDuration;
    }

    /**
     * 長さ（秒）を設定し、自オブジェクトを返します。
     * 
     * @param breachDuration
     *            長さ（秒）
     * @return 自オブジェクト
     */
    public TriggerSet withBreachDuration(Integer breachDuration) {
        setBreachDuration(breachDuration);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[resource=");
        builder.append(resource);

        builder.append(", upperThreshold=");
        builder.append(upperThreshold);

        builder.append(", breachDuration=");
        builder.append(breachDuration);

        builder.append("]");

        return builder.toString();

    }

}
