/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * タイムゾーンクラス。<br />
 * このクラスはタイムゾーンを格納します。
 */
public class TimeZone {

    /** 時間帯（開始） */
    private String startingTimeZone;

    /** 時間帯（終了） */
    private String endingTimeZone;

    /**
     * 時間帯（開始）を取得します。
     * 
     * @return 時間帯（開始）
     */
    @Query(name = "StartingTimeZone")
    public String getStartingTimeZone() {
        return startingTimeZone;
    }

    /**
     * 時間帯（開始）を設定します。
     * 
     * @param startingTimeZone
     *            時間帯（開始）
     */
    public void setStartingTimeZone(String startingTimeZone) {
        this.startingTimeZone = startingTimeZone;
    }

    /**
     * 時間帯（開始）を設定し、自オブジェクトを返します。
     * 
     * @param startingTimeZone
     *            時間帯（開始）
     * @return 自オブジェクト
     */
    public TimeZone withStartingTimeZone(
        String startingTimeZone) {
        setStartingTimeZone(startingTimeZone);
        return this;
    }

    /**
     * 時間帯（終了）を取得します。
     * 
     * @return 時間帯（終了）
     */
    @Query(name = "EndingTimeZone")
    public String getEndingTimeZone() {
        return endingTimeZone;
    }

    /**
     * 時間帯（終了）を設定します。
     * 
     * @param endingTimeZone
     *            時間帯（終了）
     */
    public void
        setEndingTimeZone(String endingTimeZone) {
        this.endingTimeZone = endingTimeZone;
    }

    /**
     * 時間帯（終了）を設定し、自オブジェクトを返します。
     * 
     * @param endingTimeZone
     *            時間帯（終了）
     * @return 自オブジェクト
     */
    public TimeZone
        withEndingTimeZone(String endingTimeZone) {
        setEndingTimeZone(endingTimeZone);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[startingTimeZone=");
        builder.append(startingTimeZone);

        builder.append(", endingTimeZone=");
        builder.append(endingTimeZone);

        builder.append("]");

        return builder.toString();

    }

}
