/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

/**
 * 処理詳細クラス。<br />
 * このクラスは処理詳細を格納します。
 */
public class ScallingLogDetails {

    /** リソース */
    private String resource;

    /** 条件「以上」の閾値 */
    private Double upperThreshold;

    /** 現在のサーバー台数 */
    private Integer currentServersCount;

    /** スケールアウト・縮退台数 */
    private Integer changeInCapacity;

    /** リソース値 */
    private Integer resourceValue;
    
    /**
     * リソースを取得します。
     * 
     * @return リソース
     */
    public String getResource() {
        return resource;
    }

    /**
     * リソースを設定します。
     * 
     * @param resource
     *            リソース
     */
    public void setResource(String resource) {
        this.resource = resource;
    }

    /**
     * リソースを設定し、自オブジェクトを返します。
     * 
     * @param resource
     *            リソース
     * @return 自オブジェクト
     */
    public ScallingLogDetails withResource(String resource) {
        setResource(resource);
        return this;
    }

    /**
     * 条件「以上」の閾値を取得します。
     * 
     * @return 条件「以上」の閾値
     */
    public Double getUpperThreshold() {
        return upperThreshold;
    }

    /**
     * 条件「以上」の閾値を設定します。
     * 
     * @param upperThreshold
     *            条件「以上」の閾値
     */
    public void setUpperThreshold(Double upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    /**
     * 条件「以上」の閾値を設定し、自オブジェクトを返します。
     * 
     * @param upperThreshold
     *            条件「以上」の閾値
     * @return 自オブジェクト
     */
    public ScallingLogDetails withUpperThreshold(Double upperThreshold) {
        setUpperThreshold(upperThreshold);
        return this;
    }

    /**
     * 現在のサーバー台数を取得します。
     * 
     * @return 現在のサーバー台数
     */
    public Integer getCurrentServersCount() {
        return currentServersCount;
    }

    /**
     * 現在のサーバー台数を設定します。
     * 
     * @param currentServersCount
     *            現在のサーバー台数
     */
    public void setCurrentServersCount(Integer currentServersCount) {
        this.currentServersCount = currentServersCount;
    }

    /**
     * 現在のサーバー台数を設定し、自オブジェクトを返します。
     * 
     * @param currentServersCount
     *            現在のサーバー台数
     * @return 自オブジェクト
     */
    public ScallingLogDetails withCurrentServersCount(Integer currentServersCount) {
        setCurrentServersCount(currentServersCount);
        return this;
    }

    /**
     * スケールアウト・縮退台数を取得します。
     * 
     * @return スケールアウト・縮退台数
     */
    public Integer getChangeInCapacity() {
        return changeInCapacity;
    }

    /**
     * スケールアウト・縮退台数を設定します。
     * 
     * @param changeInCapacity
     *            スケールアウト・縮退台数
     */
    public void setChangeInCapacity(Integer changeInCapacity) {
        this.changeInCapacity = changeInCapacity;
    }

    /**
     * スケールアウト・縮退台数を設定し、自オブジェクトを返します。
     * 
     * @param changeInCapacity
     *            スケールアウト・縮退台数
     * @return 自オブジェクト
     */
    public ScallingLogDetails withChangeInCapacity(Integer changeInCapacity) {
        setChangeInCapacity(changeInCapacity);
        return this;
    }


    /**
     * リソース値を取得します。
     * 
     * @return リソース値
     */
    public Integer getResourceValue() {
        return resourceValue;
    }

    /**
     * リソース値を設定します。
     * 
     * @param resourceValue
     *            リソース値
     */
    public void setResourceValue(Integer resourceValue) {
        this.resourceValue = resourceValue;
    }

    /**
     * リソース値を設定し、自オブジェクトを返します。
     * 
     * @param resourceValue
     *            リソース値
     * @return 自オブジェクト
     */
    public ScallingLogDetails withResourceValue(Integer resourceValue) {
        setResourceValue(resourceValue);
        return this;
    }

    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[resource=");
        builder.append(resource);

        builder.append(", upperThreshold=");
        builder.append(upperThreshold);

        builder.append(", currentServersCount=");
        builder.append(currentServersCount);

        builder.append(", changeInCapacity=");
        builder.append(changeInCapacity);

        builder.append(", resourceValue=");
        builder.append(resourceValue);
        
        builder.append("]");

        return builder.toString();
    }

}
