/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * オートスケールのトリガークラス。<br />
 * このオートスケールのトリガー情報を格納します。
 */
public class ScalingTrigger {

    /** オートスケールのトリガーにするリソース名 */
    private String resource;

    /** 条件「以上」の閾値 */
    private Double upperThreshold;

    /** 長さ(単位 : 秒) */
    private Integer breachDuration;

    /**
     * オートスケールのトリガーにするリソース名を取得します。
     *
     * @return オートスケールのトリガーにするリソース名
     */
    @Query(name = "Resource", require = true)
    public String getResource() {
        return resource;
    }

    /**
     * オートスケールのトリガーにするリソース名を設定します。
     *
     * @param resource
     *            オートスケールのトリガーにするリソース名
     */
    public void setResource(String resource) {
        this.resource = resource;
    }

    /**
     * オートスケールのトリガーにするリソース名を設定し、自オブジェクトを返します。
     * 
     * @param resource
     *            オートスケールのトリガーにするリソース名
     * @return 自オブジェクト
     */
    public ScalingTrigger withResource(String resource) {
        setResource(resource);
        return this;
    }

    /**
     * 条件「以上」の閾値を取得します。
     * 
     * @return 条件「以上」の閾値
     */
    @Query(name = "UpperThreshold", require = true)
    public Double getUpperThreshold() {
        return upperThreshold;
    }

    /**
     * 条件「以上」の閾値を設定します。
     * 
     * @param upperThreshold
     *            条件「以上」の閾値
     */
    public void setUpperThreshold(Double upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    /**
     * 条件「以上」の閾値を設定し、自オブジェクトを返します。
     * 
     * @param upperThreshold
     *            条件「以上」の閾値
     * @return 自オブジェクト
     */
    public ScalingTrigger withUpperThreshold(Double upperThreshold) {
        setUpperThreshold(upperThreshold);
        return this;
    }

    /**
     * 長さ(単位 : 秒)を取得します。
     * 
     * @return 長さ(単位 : 秒)
     */
    @Query(name = "BreachDuration")
    public Integer getBreachDuration() {
        return breachDuration;
    }

    /**
     * 長さ(単位 : 秒)を設定します。
     * 
     * @param breachDuration
     *            長さ(単位 : 秒)
     */
    public void setBreachDuration(Integer breachDuration) {
        this.breachDuration = breachDuration;
    }

    /**
     * 長さ(単位 : 秒)を設定し、自オブジェクトを返します。
     * 
     * @param breachDuration
     *            長さ(単位 : 秒)
     * @return 自オブジェクト
     */
    public ScalingTrigger withBreachDuration(Integer breachDuration) {
        setBreachDuration(breachDuration);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[resource=");
        builder.append(resource);

        builder.append(", upperThreshold=");
        builder.append(upperThreshold);

        builder.append(", breachDuration=");
        builder.append(breachDuration);

        builder.append("]");

        return builder.toString();

    }

}
