/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * スケールアウトスケジュールクラス。<br />
 * このクラスはスケールアウトのスケジュールを格納します。
 *
 */
public class ScalingSchedule {

    /** スケールアウトを有効にする時間帯 */
    private TimeZone timeZone;

    /** スケールアウトを有効にする曜日 */
    private Day day;

    /** スケールアウトを有効にする月内日 */
    private DDay dDay;

    /** スケールアウトを有効にする月 */
    private Month month;

    /**
     * スケールアウトを有効にする時間帯を取得します。
     * 
     * @return スケールアウトを有効にする時間帯
     */
    @Query(name = "TimeZone")
    public TimeZone getTimeZone() {
        return timeZone;
    }

    /**
     * スケールアウトを有効にする時間帯を設定します。
     * 
     * @param timeZone
     *            スケールアウトを有効にする時間帯
     */
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    /**
     * スケールアウトを有効にする時間帯を設定し、自オブジェクトを返します。
     * 
     * @param timeZone
     *            スケールアウトを有効にする時間帯
     * @return 自オブジェクト
     */
    public ScalingSchedule withTimeZone(TimeZone timeZone) {
        setTimeZone(timeZone);
        return this;
    }

    /**
     * スケールアウトを有効にする曜日を取得します。
     * 
     * @return スケールアウトを有効にする曜日
     */
    @Query(name = "Day")
    public Day getDay() {
        return day;
    }

    /**
     * スケールアウトを有効にする曜日を設定します。
     * 
     * @param day
     *            スケールアウトを有効にする曜日
     */
    public void setDay(Day day) {
        this.day = day;
    }

    /**
     * スケールアウトを有効にする曜日を設定し、自オブジェクトを返します。
     * 
     * @param day
     *            スケールアウトを有効にする曜日
     * @return 自オブジェクト
     */
    public ScalingSchedule withDay(Day day) {
        this.day = day;
        return this;
    }

    /**
     * スケールアウトを有効にする月内日を取得します。
     * 
     * @return スケールアウトを有効にする月内日
     */
    @Query(name = "DDay")
    public DDay getDDay() {
        return dDay;
    }

    /**
     * スケールアウトを有効にする月内日を設定します。
     * 
     * @param dDay
     *            スケールアウトを有効にする月内日
     */
    public void setDDay(DDay dDay) {
        this.dDay = dDay;
    }

    /**
     * スケールアウトを有効にする月内日を設定し、自オブジェクトを返します。
     * 
     * @param dDay
     *            スケールアウトを有効にする月内日
     * @return 自オブジェクト
     */
    public ScalingSchedule withDDay(DDay dDay) {
        setDDay(dDay);
        return this;
    }

    /**
     * スケールアウトを有効にする月を取得します。
     * 
     * @return スケールアウトを有効にする月
     */
    @Query(name = "Month")
    public Month getMonth() {
        return month;
    }

    /**
     * スケールアウトを有効にする月を設定します。
     * 
     * @param month
     *            スケールアウトを有効にする月
     */
    public void setMonth(Month month) {
        this.month = month;
    }

    /**
     * スケールアウトを有効にする月を設定し、自オブジェクトを返します。
     * 
     * @param month
     *            スケールアウトを有効にする月
     * @return 自オブジェクト
     */
    public ScalingSchedule withMonth(Month month) {
        setMonth(month);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[timeZone=");
        builder.append(timeZone);

        builder.append(", Day=");
        builder.append(day);

        builder.append(", DDay=");
        builder.append(dDay);

        builder.append(", month=");
        builder.append(month);

        builder.append("]");

        return builder.toString();

    }

}
