/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.autoscale.model.transform.NiftyDescribeScalingActivitiesResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeScalingActivities処理結果クラス。<br />
 * このクラスはNiftyDescribeScalingActivitiesのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeScalingActivitiesResponse")
@XStreamConverter(NiftyDescribeScalingActivitiesResultConverter.class)
public class NiftyDescribeScalingActivitiesResult extends Result {

    /** リクエスト識別子 */
    private String requestId;

    /** オートスケール名 */
    private String autoScalingGroupName;

    /** ログ情報セット */
    private List<LogSet> logSet;

    /**
     * リクエスト識別子を取得します。
     * 
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     * 
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     * 
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * オートスケール名を取得します。
     * 
     * @return オートスケール名
     */
    public String getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * オートスケール名を設定します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     */
    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    /**
     * オートスケール名を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesResult
        withAutoScalingGroupName(String autoScalingGroupName) {
        setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    /**
     * ログ情報セットを取得します。
     * 
     * @return ログ情報セット
     */
    public List<LogSet> getLogSet() {
        return logSet;
    }

    /**
     * ログ情報セットを設定します。
     * 
     * @param logSet
     *            ログ情報セット
     */
    public void setLogSet(List<LogSet> logSet) {
        this.logSet = logSet;
    }

    /**
     * ログ情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param logSet
     *            ログ情報セットの配列
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesResult withLogSet(LogSet... logSet) {

        if (this.logSet == null) {
            this.logSet = new ArrayList<LogSet>();
        }

        for (LogSet work : logSet) {
            getLogSet().add(work);
        }

        return this;
    }

    /**
     * ログ情報セットを設定し、自オブジェクトを返します。
     * 
     * @param groupSet
     *            ログ情報セット
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesResult withLogSet(Collection<LogSet> logSet) {

        if (this.logSet == null) {
            this.logSet = new ArrayList<LogSet>();
        }

        getLogSet().addAll(logSet);

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[requestId=");
        builder.append(requestId);

        builder.append(", autoScalingGroupName=");
        builder.append(autoScalingGroupName);

        builder.append(", logSet=");
        builder.append(logSet);

        builder.append("]");

        return builder.toString();
    }

}
