/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeScalingActivitiesリクエストクラス。<br />
 * このクラスはNiftyDescribeScalingActivitiesへのリクエストを構築します。
 * 
 */
@Action("NiftyDescribeScalingActivities")
public class NiftyDescribeScalingActivitiesRequest implements Request {

    /** オートスケール名 */
    private String autoScalingGroupName;

    /** 絞り込み条件（日）From */
    private String activityDateFrom;

    /** 絞り込み条件（日）To */
    private String activityDateTo;

    /** 日付範囲 */
    private Range range;

    /**
     * オートスケール名を取得します。
     * 
     * @return オートスケール名
     */
    @Query(name = "AutoScalingGroupName", require = true)
    public String getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * オートスケール名を設定します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     */
    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    /**
     * オートスケール名を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesRequest
        withAutoScalingGroupName(String autoScalingGroupName) {
        setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    /**
     * 絞り込み条件（日）Fromを取得します。
     * 
     * @return 絞り込み条件（日）From
     */
    @Query(name = "ActivityDateFrom")
    public String getActivityDateFrom() {
        return activityDateFrom;
    }

    /**
     * 絞り込み条件（日）Fromを設定します。
     * 
     * @param activityDateFrom
     *            絞り込み条件（日）From
     */
    public void setActivityDateFrom(String activityDateFrom) {
        this.activityDateFrom = activityDateFrom;
    }

    /**
     * 絞り込み条件（日）Fromを設定し、自オブジェクトを返します。
     * 
     * @param activityDateFrom
     *            絞り込み条件（日）From
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesRequest withActivityDateFrom(String activityDateFrom) {
        setActivityDateFrom(activityDateFrom);
        return this;
    }

    /**
     * 絞り込み条件（日）Toを取得します。
     * 
     * @return 絞り込み条件（日）To
     */
    @Query(name = "ActivityDateTo")
    public String getActivityDateTo() {
        return activityDateTo;
    }

    /**
     * 絞り込み条件（日）Toを設定します。
     * 
     * @param activityDateTo
     *            絞り込み条件（日）To
     */
    public void setActivityDateTo(String activityDateTo) {
        this.activityDateTo = activityDateTo;
    }

    /**
     * 絞り込み条件（日）Toを設定し、自オブジェクト返します。
     * 
     * @param activityDateTo
     *            絞り込み条件（日）To
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesRequest withActivityDateTo(String activityDateTo) {
        setActivityDateTo(activityDateTo);
        return this;
    }

    /**
     * 日付範囲を取得します。
     * 
     * @return 日付範囲
     */
    @Query(name = "Range")
    public Range getRange() {
        return range;
    }

    /**
     * 日付範囲を設定します。
     * 
     * @param range
     *            日付範囲
     */
    public void setRange(Range range) {
        this.range = range;
    }

    /**
     * 日付範囲を設定し、自オブジェクトを返します。
     * 
     * @param range
     *            日付範囲
     * @return 自オブジェクト
     */
    public NiftyDescribeScalingActivitiesRequest withRange(Range range) {
        setRange(range);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[autoScalingGroupName=");
        builder.append(autoScalingGroupName);

        builder.append(", activityDateFrom=");
        builder.append(activityDateFrom);

        builder.append(", activityDateTo=");
        builder.append(activityDateTo);

        builder.append(", range=");
        builder.append(range);

        builder.append("]");

        return builder.toString();
    }

}
