/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.autoscale.model.transform.NiftyDescribeAutoScalingGroupsResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeAutoScalingGroups結果処理クラス。<br />
 * このクラスはNiftyDescribeAutoScalingGroupsのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeAutoScalingGroupsResponse")
@XStreamConverter(NiftyDescribeAutoScalingGroupsResultConverter.class)
public class NiftyDescribeAutoScalingGroupsResult extends Result {

    /** リクエスト識別子 */
    private String requestId;

    /** 取得したオートスケール情報セット */
    private List<AutoScalingReservationSet> autoScalingReservationSet;

    /**
     * リクエスト識別子を取得します。
     * 
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     * 
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     * 
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyDescribeAutoScalingGroupsResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * 取得したオートスケール情報セットを取得します。
     * 
     * @return 取得したオートスケール情報セット
     */
    public List<AutoScalingReservationSet> getAutoScalingReservationSet() {
        return autoScalingReservationSet;
    }

    /**
     * 取得したオートスケール情報セットを設定します。
     * 
     * @param autoScalingReservationSet
     *            取得したオートスケール情報セット
     */
    public void
        setAutoScalingReservationSet(List<AutoScalingReservationSet> autoScalingReservationSet) {
        this.autoScalingReservationSet = autoScalingReservationSet;
    }

    /**
     * 取得したオートスケール情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingReservationSet
     *            取得したオートスケール情報セットの配列
     * @return 自オブジェクト
     */
    public NiftyDescribeAutoScalingGroupsResult
        withAutoScalingReservationSet(AutoScalingReservationSet... autoScalingReservationSet) {

        if (this.autoScalingReservationSet == null) {
            this.autoScalingReservationSet = new ArrayList<AutoScalingReservationSet>();
        }

        for (AutoScalingReservationSet work : autoScalingReservationSet) {
            getAutoScalingReservationSet().add(work);
        }

        return this;
    }

    /**
     * 取得したオートスケール情報セットを設定し、自オブジェクトを返します。
     * 
     * @param autoScalingReservationSet
     *            取得したオートスケール情報セット
     * @return 自オブジェクト
     */
    public NiftyDescribeAutoScalingGroupsResult withAutoScalingReservationSet(
        Collection<AutoScalingReservationSet> autoScalingReservationSet) {

        if (this.autoScalingReservationSet == null) {
            this.autoScalingReservationSet = new ArrayList<AutoScalingReservationSet>();
        }

        getAutoScalingReservationSet().addAll(autoScalingReservationSet);

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[requestId=");
        builder.append(requestId);

        builder.append(", autoScalingReservationSet=");
        builder.append(autoScalingReservationSet);

        builder.append("]");

        return builder.toString();
    }

}
