/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeAutoScalingGroupsリクエストクラス。<br />
 * このクラスはNiftyDescribeAutoScalingGroupsへのリクエストを構築します。
 *
 */
@Action("NiftyDescribeAutoScalingGroups")
public class NiftyDescribeAutoScalingGroupsRequest implements Request {

    /** オートスケール名 */
    private List<String> autoScalingGroupName;

    /**
     * オートスケール名を取得します。
     * 
     * @return オートスケール名
     */
    @Query(name = "AutoScalingGroupName")
    public List<String> getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * オートスケール名を設定します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     */
    public void setAutoScalingGroupName(List<String> autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    /**
     * オートスケール名の配列を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeAutoScalingGroupsRequest
        withAutoScalingGroupName(String... autoScalingGroupName) {

        if (this.autoScalingGroupName == null) {
            this.autoScalingGroupName = new ArrayList<String>();
        }

        for (String work : autoScalingGroupName) {
            getAutoScalingGroupName().add(work);
        }

        return this;
    }

    /**
     * オートスケール名を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     * @return 自オブジェクト
     */
    public NiftyDescribeAutoScalingGroupsRequest
        withAutoScalingGroupName(Collection<String> autoScalingGroupName) {

        if (this.autoScalingGroupName == null) {
            this.autoScalingGroupName = new ArrayList<String>();
        }

        getAutoScalingGroupName().addAll(autoScalingGroupName);

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[autoScalingGroupName=");
        builder.append(autoScalingGroupName);

        builder.append("]");

        return builder.toString();

    }

}
