/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteAutoScalingGroupリクエストクラス。<br />
 * このクラスはNiftyDeleteAutoScalingGroupへのリクエストを構築します。
 */
@Action("NiftyDeleteAutoScalingGroup")
public class NiftyDeleteAutoScalingGroupRequest implements Request {

    /** オートスケール名 */
    private String autoScalingGroupName;

    /**
     * オートスケール名を取得します。
     * 
     * @return オートスケール名
     */
    @Query(name = "AutoScalingGroupName", require = true)
    public String getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * オートスケール名を設定します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     */
    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    /**
     * オートスケール名を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     * @return 自オブジェクト
     */
    public NiftyDeleteAutoScalingGroupRequest
        withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[autoScalingGroupName=");
        builder.append(autoScalingGroupName);

        builder.append("]");

        return builder.toString();

    }

}
