/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyCreateAutoScalingGroupリクエストクラス。<br />
 * このクラスはNiftyCreateAutoScalingGroupへのリクエストを構築します。
 *
 */
@Action("NiftyCreateAutoScalingGroup")
public class NiftyCreateAutoScalingGroupRequest implements Request {

    /** オートスケール名 */
    private String autoScalingGroupName;

    /** メモ */
    private String description;

    /** イメージID */
    private String imageId;

    /** サーバータイプ */
    private String instanceType;

    /** ファイアウォールグループ名 */
    private List<String> securityGroup;

    /** オートスケールのトリガー */
    private List<ScalingTrigger> scalingTrigger;

    /** スケールアウトの条件 */
    private String scaleoutCondition;

    /** ロードバランサー情報 */
    private List<LoadBalancers> loadBalancers;

    /** サーバーの最小台数 */
    private Integer minSize;

    /** サーバーの最大台数 */
    private Integer maxSize;

    /** 有効時間 */
    private Integer instanceLifecycleLimit;

    /** スケールアウト開始間隔 */
    private Integer scaleout;

    /** 縮退開始間隔 */
    private Integer defaultCooldown;

    /** スケールアウト・縮退台数 */
    private Integer changeInCapacity;

    /** スケールアウトスケジュール情報 */
    private List<ScalingSchedule> scalingSchedule;

    /**
     * オートスケール名を取得します。
     *
     * @return オートスケール名
     */
    @Query(name = "AutoScalingGroupName", require = true)
    public String getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * オートスケール名を設定します。
     *
     * @param autoScalingGroupName
     *            オートスケール名
     */
    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    /**
     * オートスケール名を設定し、自オブジェクトを返します。
     *
     * @param autoScalingGroupName
     *            オートスケール名
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withAutoScalingGroupName(String autoScalingGroupName) {
        setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    /**
     * メモを取得します。
     *
     * @return メモ
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * メモを設定します。
     *
     * @param description
     *            メモ
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモを設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * イメージIDを取得します。
     *
     * @return イメージID
     */
    @Query(name = "ImageId", require = true)
    public String getImageId() {
        return imageId;
    }

    /**
     * イメージIDを設定します。
     *
     * @param imageId
     *            イメージID
     */
    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    /**
     * イメージIDを設定し、自オブジェクトを返します。
     *
     * @param imageId
     *            イメージID
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withImageId(String imageId) {
        setImageId(imageId);
        return this;
    }

    /**
     * サーバータイプを取得します。
     * 
     * @return サーバータイプ
     */
    @Query(name = "InstanceType")
    public String getInstanceType() {
        return instanceType;
    }

    /**
     * サーバータイプを設定します。
     * 
     * @param instanceType
     *            サーバータイプ
     */
    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    /**
     * サーバータイプを設定し、自オブジェクトを返します。
     *
     * @param instanceType
     *            サーバータイプ
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withInstanceType(String instanceType) {
        setInstanceType(instanceType);
        return this;
    }

    /**
     * ファイアウォールグループ名を取得します。
     * 
     * @return ファイアウォールグループ名
     */
    @Query(name = "SecurityGroup")
    public List<String> getSecurityGroup() {
        return securityGroup;
    }

    /**
     * ファイアウォールグループ名を設定します。
     * 
     * @param securityGroup
     *            ファイアウォールグループ名
     */
    public void setSecurityGroup(List<String> securityGroup) {
        this.securityGroup = securityGroup;
    }

    /**
     * ファイアウォールグループ名の配列を設定し、自オブジェクトを返します。
     * 
     * @param securityGroup
     *            ファイアウォールグループ名の配列
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withSecurityGroup(String... securityGroup) {

        if (this.securityGroup == null) {
            this.securityGroup = new ArrayList<String>();
        }

        for (String work : securityGroup) {
            getSecurityGroup().add(work);
        }

        return this;
    }

    /**
     * ファイアウォールグループ名を設定し、自オブジェクトを返します。
     * 
     * @param securityGroup
     *            ファイアウォールグループ名
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withSecurityGroup(Collection<String> securityGroup) {

        if (this.securityGroup == null) {
            this.securityGroup = new ArrayList<String>();
        }

        getSecurityGroup().addAll(securityGroup);

        return this;
    }

    /**
     * オートスケールのトリガーを取得します。
     * 
     * @return オートスケールのトリガー
     */
    @Query(name = "ScalingTrigger")
    public List<ScalingTrigger> getScalingTrigger() {
        return scalingTrigger;
    }

    /**
     * オートスケールのトリガーを設定します。
     * 
     * @param scalingTrigger
     *            オートスケールのトリガー
     */
    public void setScalingTrigger(List<ScalingTrigger> scalingTrigger) {
        this.scalingTrigger = scalingTrigger;
    }

    /**
     * オートスケールのトリガーの配列を設定し、自オブジェクトを返します。
     * 
     * @param scalingTrigger
     *            オートスケールのトリガーの配列
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withScalingTrigger(ScalingTrigger... scalingTrigger) {

        if (this.scalingTrigger == null) {
            this.scalingTrigger = new ArrayList<ScalingTrigger>();
        }

        for (ScalingTrigger work : scalingTrigger) {
            getScalingTrigger().add(work);
        }

        return this;
    }

    /**
     * オートスケールのトリガーを設定し、自オブジェクトを返します。
     * 
     * @param scalingTrigger
     *            オートスケールのトリガー
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withScalingTrigger(Collection<ScalingTrigger> scalingTrigger) {

        if (this.scalingTrigger == null) {
            this.scalingTrigger = new ArrayList<ScalingTrigger>();
        }

        getScalingTrigger().addAll(scalingTrigger);

        return this;
    }

    /**
     * スケールアウトの条件を取得します。
     * 
     * @return スケールアウトの条件
     */
    @Query(name = "ScaleoutCondition", require = true)
    public String getScaleoutCondition() {
        return scaleoutCondition;
    }

    /**
     * スケールアウトの条件を設定します。
     * 
     * @param scaleoutCondition
     *            スケールアウトの条件
     */
    public void setScaleoutCondition(String scaleoutCondition) {
        this.scaleoutCondition = scaleoutCondition;
    }

    /**
     * スケールアウトの条件を設定し、自オブジェクトを返します。
     * 
     * @param scaleoutCondition
     *            スケールアウトの条件
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withScaleoutCondition(String scaleoutCondition) {
        setScaleoutCondition(scaleoutCondition);
        return this;
    }

    /**
     * ロードバランサー情報を取得します。
     * 
     * @return ロードバランサー情報
     */
    @Query(name = "LoadBalancers")
    public List<LoadBalancers> getLoadBalancers() {
        return loadBalancers;
    }

    /**
     * ロードバランサー情報を設定します。
     * 
     * @param loadBalancers
     *            ロードバランサー情報
     */
    public void setLoadBalancers(List<LoadBalancers> loadBalancers) {
        this.loadBalancers = loadBalancers;
    }

    /**
     * ロードバランサー情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param loadBalancers
     *            ロードバランサー情報
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withLoadBalancers(LoadBalancers... loadBalancers) {

        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList<LoadBalancers>();
        }

        for (LoadBalancers work : loadBalancers) {
            getLoadBalancers().add(work);
        }

        return this;
    }

    /**
     * ロードバランサー情報を設定し、自オブジェクトを返します。
     * 
     * @param loadBalancers
     *            ロードバランサー情報
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withLoadBalancers(Collection<LoadBalancers> loadBalancers) {

        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList<LoadBalancers>();
        }

        getLoadBalancers().addAll(loadBalancers);

        return this;
    }

    /**
     * サーバーの最小台数を取得します。
     * 
     * @return サーバーの最小台数
     */
    @Query(name = "MinSize", require = true)
    public Integer getMinSize() {
        return minSize;
    }

    /**
     * サーバーの最小台数を設定します。
     * 
     * @param minSize
     *            サーバーの最小台数
     */
    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    /**
     * サーバーの最小台数を設定し、自オブジェクトを返します。
     * 
     * @param minSize
     *            サーバーの最小台数
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withMinSize(Integer minSize) {
        setMinSize(minSize);
        return this;
    }

    /**
     * サーバーの最大台数を取得します。
     * 
     * @return サーバーの最大台数
     */
    @Query(name = "MaxSize", require = true)
    public Integer getMaxSize() {
        return maxSize;
    }

    /**
     * サーバーの最大台数を設定します。
     * 
     * @param maxSize
     *            サーバーの最大台数
     */
    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    /**
     * サーバーの最大台数を設定し、自オブジェクトを返します。
     * 
     * @param maxSize
     *            サーバーの最大台数
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withMaxSize(Integer maxSize) {
        setMaxSize(maxSize);
        return this;
    }

    /**
     * 有効時間を取得します。
     * 
     * @return 有効時間
     */
    @Query(name = "InstanceLifecycleLimit")
    public Integer getInstanceLifecycleLimit() {
        return instanceLifecycleLimit;
    }

    /**
     * 有効時間を設定します。
     * 
     * @param instanceLifecycleLimit
     *            有効時間
     */
    public void setInstanceLifecycleLimit(Integer instanceLifecycleLimit) {
        this.instanceLifecycleLimit = instanceLifecycleLimit;
    }

    /**
     * 有効時間を設定し、自オブジェクトを返します。
     * 
     * @param instanceLifecycleLimit
     *            有効時間
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withInstanceLifecycleLimit(Integer instanceLifecycleLimit) {
        setInstanceLifecycleLimit(instanceLifecycleLimit);
        return this;
    }

    /**
     * スケールアウト開始間隔を取得します。
     * 
     * @return スケールアウト開始間隔
     */
    @Query(name = "Scaleout")
    public Integer getScaleout() {
        return scaleout;
    }

    /**
     * スケールアウト開始間隔を設定します。
     * 
     * @param scaleout
     *            スケールアウト開始間隔
     */
    public void setScaleout(Integer scaleout) {
        this.scaleout = scaleout;
    }

    /**
     * スケールアウト開始間隔を設定し、自オブジェクトを返します。
     * 
     * @param scaleout
     *            スケールアウト開始間隔
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withScaleout(Integer scaleout) {
        setScaleout(scaleout);
        return this;
    }

    /**
     * 縮退開始間隔を取得します。
     * 
     * @return 縮退開始間隔
     */
    @Query(name = "DefaultCooldown")
    public Integer getDefaultCooldown() {
        return defaultCooldown;
    }

    /**
     * 縮退開始間隔を設定します。
     * 
     * @param defaultCooldown
     *            縮退開始間隔
     */
    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    /**
     * 縮退開始間隔を設定し、自オブジェクトを返します。
     * 
     * @param defaultCooldown
     *            縮退開始間隔
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withDefaultCooldown(Integer defaultCooldown) {
        setDefaultCooldown(defaultCooldown);
        return this;
    }

    /**
     * スケールアウト・縮退台数を取得します。
     * 
     * @return スケールアウト・縮退台数
     */
    @Query(name = "ChangeInCapacity", require = true)
    public Integer getChangeInCapacity() {
        return changeInCapacity;
    }

    /**
     * スケールアウト・縮退台数を設定します。
     * 
     * @param changeInCapacity
     *            スケールアウト・縮退台数
     */
    public void setChangeInCapacity(Integer changeInCapacity) {
        this.changeInCapacity = changeInCapacity;
    }

    /**
     * スケールアウト・縮退台数を設定し、自オブジェクトを返します。
     * 
     * @param changeInCapacity
     *            スケールアウト・縮退台数
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest withChangeInCapacity(Integer changeInCapacity) {
        setChangeInCapacity(changeInCapacity);
        return this;
    }

    /**
     * スケールアウトスケジュール情報を取得します。
     * 
     * @return スケールアウトスケジュール情報
     */
    @Query(name = "ScalingSchedule")
    public List<ScalingSchedule> getScalingSchedule() {
        return scalingSchedule;
    }

    /**
     * スケールアウトスケジュール情報を設定します。
     * 
     * @param scalingSchedule
     *            スケールアウトスケジュール情報
     */
    public void setScalingSchedule(List<ScalingSchedule> scalingSchedule) {
        this.scalingSchedule = scalingSchedule;
    }

    /**
     * スケールアウトスケジュール情報の配列を設定し、自オブジェクトを返します。
     * 
     * @param scalingSchedule
     *            スケールアウトスケジュール情報の配列
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withScalingSchedule(ScalingSchedule... scalingSchedule) {

        if (this.scalingSchedule == null) {
            this.scalingSchedule = new ArrayList<ScalingSchedule>();
        }

        for (ScalingSchedule work : scalingSchedule) {
            getScalingSchedule().add(work);
        }

        return this;
    }

    /**
     * スケールアウトスケジュール情報を設定し、自オブジェクトを返します。
     * 
     * @param scalingSchedule
     *            スケールアウトスケジュール情報
     * @return 自オブジェクト
     */
    public NiftyCreateAutoScalingGroupRequest
        withScalingSchedule(Collection<ScalingSchedule> scalingSchedule) {

        if (this.scalingSchedule == null) {
            this.scalingSchedule = new ArrayList<ScalingSchedule>();
        }

        getScalingSchedule().addAll(scalingSchedule);

        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[autoScalingGroupName=");
        builder.append(autoScalingGroupName);

        builder.append(", description=");
        builder.append(description);

        builder.append(", imageId=");
        builder.append(imageId);

        builder.append(", instanceType=");
        builder.append(instanceType);

        builder.append(", securityGroup=");
        builder.append(securityGroup);

        builder.append(", scalingTrigger=");
        builder.append(scalingTrigger);

        builder.append(", scaleoutCondition=");
        builder.append(scaleoutCondition);

        builder.append(", loadBalancers=");
        builder.append(loadBalancers);

        builder.append(", minSize=");
        builder.append(minSize);

        builder.append(", maxSize=");
        builder.append(maxSize);

        builder.append(", instanceLifecycleLimit=");
        builder.append(instanceLifecycleLimit);

        builder.append(", scaleout=");
        builder.append(scaleout);

        builder.append(", defaultCooldown=");
        builder.append(defaultCooldown);

        builder.append(", changeInCapacity=");
        builder.append(changeInCapacity);

        builder.append(", scalingSchedule=");
        builder.append(scalingSchedule);

        builder.append("]");

        return builder.toString();

    }

}
