/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 月情報クラス。<br />
 * このクラスは開始月と終了月を格納します。
 */
@XStreamAlias("Month")
public class Month {

    /** 開始月 */
    private String startingMonth;

    /** 終了月 */
    private String endingMonth;

    /**
     * 開始月を取得します。
     * 
     * @return 開始月
     */
    @Query(name = "StartingMonth")
    public String getStartingMonth() {
        return startingMonth;
    }

    /**
     * 開始月を設定します。
     * 
     * @param startingMonth
     *            開始月
     */
    public void setStartingMonth(String startingMonth) {
        this.startingMonth = startingMonth;
    }

    /**
     * 開始月を設定し、自オブジェクトを返します。
     * 
     * @param startingMonth
     *            開始月
     * @return 自オブジェクト
     */
    public Month withStartingMonth(String startingMonth) {
        setStartingMonth(startingMonth);
        return this;
    }

    /**
     * 終了月を取得します。
     * 
     * @return 終了月
     */
    @Query(name = "EndingMonth")
    public String getEndingMonth() {
        return endingMonth;
    }

    /**
     * 終了月を設定します。
     * 
     * @param endingMonth
     *            終了月
     */
    public void setEndingMonth(String endingMonth) {
        this.endingMonth = endingMonth;
    }

    /**
     * 終了月を設定し、自オブジェクトを返します。
     * 
     * @param endingMonth
     *            終了月
     * @return 自オブジェクト
     */
    public Month withEndingMonth(String endingMonth) {
        setEndingMonth(endingMonth);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[startingMonth=");
        builder.append(startingMonth);

        builder.append(", endingMonth=");
        builder.append(endingMonth);

        builder.append("]");

        return builder.toString();

    }

}
