/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * ログ情報クラス。<br />
 * このクラスはログ情報を格納します。
 */
@XStreamAlias("LogSet")
public class LogSet {

    /** 日時 */
    private String time;

    /** 処理内容 */
    private String process;

    /** 処理詳細 */
    private ScallingLogDetails details;

    /**
     * 日時を取得します。
     * 
     * @return 日時
     */
    public String getTime() {
        return time;
    }

    /**
     * 日時を設定します。
     * 
     * @param time
     *            日時
     */
    public void setTime(String time) {
        this.time = time;
    }

    /**
     * 日時を設定し、自オブジェクトを返します。
     * 
     * @param time
     *            日時
     * @return 自オブジェクト
     */
    public LogSet withTime(String time) {
        setTime(time);
        return this;
    }

    /**
     * 処理内容を取得します。
     * 
     * @return 処理内容
     */
    public String getProcess() {
        return process;
    }

    /**
     * 処理内容を設定します。
     * 
     * @param process
     *            処理内容
     */
    public void setProcess(String process) {
        this.process = process;
    }

    /**
     * 処理内容を設定し、自オブジェクトを返します。
     * 
     * @param process
     *            処理内容
     * @return 自オブジェクト
     */
    public LogSet withProcess(String process) {
        setProcess(process);
        return this;
    }

    /**
     * 処理詳細を取得します。
     * 
     * @return 処理詳細
     */
    public ScallingLogDetails getDetails() {
        return details;
    }

    /**
     * 処理詳細を設定します。
     * 
     * @param details
     *            処理詳細
     */
    public void setDetails(ScallingLogDetails details) {
        this.details = details;
    }

    /**
     * 処理詳細を設定し、自オブジェクトを返します。
     * 
     * @param details
     *            処理詳細
     * @return 自オブジェクト
     */
    public LogSet withDetails(ScallingLogDetails details) {
        setDetails(details);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[time=");
        builder.append(time);

        builder.append(", process=");
        builder.append(process);

        builder.append(", details=");
        builder.append(details);

        builder.append("]");

        return builder.toString();

    }

}
