/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * ロードバランサー情報クラス。<br />
 * このクラスはロードバランサー情報を格納します。
 */
public class LoadBalancers {

    /** ロードバランサー名 */
    private String name;

    /** 待ち受けポート */
    private Integer loadBalancerPort;

    /** 宛先ポート */
    private Integer instancePort;

    /**
     * ロードバランサー名を取得します。
     * 
     * @return ロードバランサー名
     */
    @Query(name = "Name")
    public String getName() {
        return name;
    }

    /**
     * ロードバランサー名を設定します。
     * 
     * @param name
     *            ロードバランサー名
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * ロードバランサー名を設定し、自オブジェクトを返します。
     * 
     * @param name
     *            ロードバランサー名
     * @return 自オブジェクト
     */
    public LoadBalancers withName(String name) {
        setName(name);
        return this;
    }

    /**
     * 待ち受けポートを取得します。
     * 
     * @return 待ち受けポート
     */
    @Query(name = "LoadBalancerPort")
    public Integer getLoadBalancerPort() {
        return loadBalancerPort;
    }

    /**
     * 待ち受けポートを設定します。
     * 
     * @param loadBalancerPort
     *            待ち受けポート
     */
    public void setLoadBalancerPort(Integer loadBalancerPort) {
        this.loadBalancerPort = loadBalancerPort;
    }

    /**
     * 待ち受けポートを設定し、自オブジェクトを返します。
     * 
     * @param loadBalancerPort
     *            待ち受けポート
     * @return 自オブジェクト
     */
    public LoadBalancers withLoadBalancerPort(Integer loadBalancerPort) {
        setLoadBalancerPort(loadBalancerPort);
        return this;
    }

    /**
     * 宛先ポートを取得します。
     * 
     * @return 宛先ポート
     */
    @Query(name = "InstancePort")
    public Integer getInstancePort() {
        return instancePort;
    }

    /**
     * 宛先ポートを設定します。
     * 
     * @param instancePort
     *            宛先ポート
     */
    public void setInstancePort(Integer instancePort) {
        this.instancePort = instancePort;
    }

    /**
     * 宛先ポートを設定し、自オブジェクトを返します。
     * 
     * @param instancePort
     *            宛先ポート
     * @return 自オブジェクト
     */
    public LoadBalancers withInstancePort(Integer instancePort) {
        setInstancePort(instancePort);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[name=");
        builder.append(name);

        builder.append(", loadBalancerPort=");
        builder.append(loadBalancerPort);

        builder.append(", instancePort=");
        builder.append(instancePort);

        builder.append("]");

        return builder.toString();

    }

}
