/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

/**
 * ファイアウォールグループ名クラス。<br />
 * このクラスはファイアウォールグループ名を格納します。
 */
public class GroupSet {

    /** ファイアウォールグループ名 */
    private String groupId;

    /**
     * ファイアウォールグループ名を取得します。
     * 
     * @return ファイアウォールグループ名
     */
    public String getGroupId() {
        return groupId;
    }

    /**
     * ファイアウォールグループ名を設定します。
     * 
     * @param groupId
     *            ファイアウォールグループ名
     */
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    /**
     * ファイアウォールグループ名を設定し、自オブジェクトを返します。
     * 
     * @param groupId
     *            ファイアウォールグループ名
     * @return 自オブジェクト
     */
    public GroupSet withGroupId(String groupId) {
        setGroupId(groupId);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[groupId=");
        builder.append(groupId);

        builder.append("]");

        return builder.toString();

    }

}
