/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 曜日設定を保持するクラス。<br />
 * このクラスは曜日設定を格納します。
 */
@XStreamAlias("ScalingScheduleDay")
public class Day {

    /** 日曜日の設定 */
    @XStreamAlias("setSunday")
    private String sunday;

    /** 月曜日の設定 */
    @XStreamAlias("setMonday")
    private String monday;

    /** 火曜日の設定 */
    @XStreamAlias("setTuesday")
    private String tuesday;

    /** 水曜日の設定 */
    @XStreamAlias("setWednesday")
    private String wednesday;

    /** 木曜日の設定 */
    @XStreamAlias("setThursday")
    private String thursday;

    /** 金曜日の設定 */
    @XStreamAlias("setFriday")
    private String friday;

    /** 土曜日の設定 */
    @XStreamAlias("setSaturday")
    private String saturday;

    /**
     * 日曜日の設定を取得します。
     * 
     * @return 日曜日の設定
     */
    @Query(name = "SetSunday")
    public String getSunday() {
        return sunday;
    }

    /**
     * 日曜日の設定を設定します。
     * 
     * @param sunday
     *            日曜日の設定
     */
    public void setSunday(String sunday) {
        this.sunday = sunday;
    }

    /**
     * 日曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param sunday
     *            日曜日の設定
     * @return 自オブジェクト
     */
    public Day withSunday(String sunday) {
        setSunday(sunday);
        return this;
    }

    /**
     * 月曜日の設定を取得します。
     * 
     * @return 月曜日の設定
     */
    @Query(name = "SetMonday")
    public String getMonday() {
        return monday;
    }

    /**
     * 月曜日の設定を設定します。
     * 
     * @param monday
     *            月曜日の設定
     */
    public void setMonday(String monday) {
        this.monday = monday;
    }

    /**
     * 月曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param monday
     *            月曜日の設定
     * @return 自オブジェクト
     */
    public Day withMonday(String monday) {
        setMonday(monday);
        return this;
    }

    /**
     * 火曜日の設定を取得します。
     * 
     * @return 火曜日の設定
     */
    @Query(name = "SetTuesday")
    public String getTuesday() {
        return tuesday;
    }

    /**
     * 火曜日の設定を設定します。
     * 
     * @param tuesday
     *            火曜日の設定
     */
    public void setTuesday(String tuesday) {
        this.tuesday = tuesday;
    }

    /**
     * 火曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param tuesday
     *            火曜日の設定
     * @return 自オブジェクト
     */
    public Day withTuesday(String tuesday) {
        this.tuesday = tuesday;
        return this;
    }

    /**
     * 水曜日の設定を取得します。
     * 
     * @return 水曜日の設定
     */
    @Query(name = "SetWednesday")
    public String getWednesday() {
        return wednesday;
    }

    /**
     * 水曜日の設定を設定します。
     * 
     * @param wednesday
     *            水曜日の設定
     */
    public void setWednesday(String wednesday) {
        this.wednesday = wednesday;
    }

    /**
     * 水曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param wednesday
     *            水曜日の設定
     * @return 自オブジェクト
     */
    public Day withWednesday(String wednesday) {
        setWednesday(wednesday);
        return this;
    }

    /**
     * 木曜日の設定を取得します。
     * 
     * @return 木曜日の設定
     */
    @Query(name = "SetThursday")
    public String getThursday() {
        return thursday;
    }

    /**
     * 木曜日の設定を設定します。
     * 
     * @param thursday
     *            木曜日の設定
     */
    public void setThursday(String thursday) {
        this.thursday = thursday;
    }

    /**
     * 木曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param thursday
     *            木曜日の設定
     * @return 自オブジェクト
     */
    public Day withThursday(String thursday) {
        setThursday(thursday);
        return this;
    }

    /**
     * 金曜日の設定を取得します。
     * 
     * @return 金曜日の設定
     */
    @Query(name = "SetFriday")
    public String getFriday() {
        return friday;
    }

    /**
     * 金曜日の設定を設定します。
     * 
     * @param friday
     *            金曜日の設定
     */
    public void setFriday(String friday) {
        this.friday = friday;
    }

    /**
     * 金曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param friday
     *            金曜日の設定
     * @return 自オブジェクト
     */
    public Day withFriday(String friday) {
        setFriday(friday);
        return this;
    }

    /**
     * 土曜日の設定を取得します。
     * 
     * @return 土曜日の設定
     */
    @Query(name = "SetSaturday")
    public String getSaturday() {
        return saturday;
    }

    /**
     * 土曜日の設定を設定します。
     * 
     * @param saturday
     *            土曜日の設定
     */
    public void setSaturday(String saturday) {
        this.saturday = saturday;
    }

    /**
     * 土曜日の設定を設定し、自オブジェクトを返します。
     * 
     * @param saturday
     *            土曜日の設定
     * @return 自オブジェクト
     */
    public Day withSaturday(String saturday) {
        setSaturday(saturday);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[sunday=");
        builder.append(sunday);

        builder.append(", monday=");
        builder.append(monday);

        builder.append(", tuesday=");
        builder.append(tuesday);

        builder.append(", wednesday=");
        builder.append(wednesday);

        builder.append(", thursday=");
        builder.append(thursday);

        builder.append(", friday=");
        builder.append(friday);

        builder.append(", saturday=");
        builder.append(saturday);

        builder.append("]");

        return builder.toString();

    }

}
