/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.nifty.cloud.sdk.annotation.Query;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 月内日を保持するクラス。<br />
 * このクラスは月内日を格納します。
 */
@XStreamAlias("ScalingScheduleDDay")
public class DDay {

    /** 月内開始日 */
    private String startingDDay;

    /** 月内終了日 */
    private String endingDDay;

    /**
     * 月内開始日を取得します。
     * 
     * @return 月内開始日
     */
    @Query(name = "StartingDDay")
    public String getStartingDDay() {
        return startingDDay;
    }

    /**
     * 月内開始日を設定します。
     * 
     * @param startingDDay
     *            月内開始日
     */
    public void setStartingDDay(String startingDDay) {
        this.startingDDay = startingDDay;
    }

    /**
     * 月内開始日を設定し、自オブジェクトを返します。
     * 
     * @param startingDDay
     *            月内開始日
     * @return 自オブジェクト
     */
    public DDay withStartingDDay(String startingDDay) {
        setStartingDDay(startingDDay);
        return this;
    }

    /**
     * 月内終了日を取得します。
     * 
     * @return 月内終了日
     */
    @Query(name = "EndingDDay")
    public String getEndingDDay() {
        return endingDDay;
    }

    /**
     * 月内終了日を設定します。
     * 
     * @param endingDDay
     *            月内終了日
     */
    public void setEndingDDay(String endingDDay) {
        this.endingDDay = endingDDay;
    }

    /**
     * 月内終了日を設定し、自オブジェクトを返します。
     * 
     * @param endingDDay
     *            月内終了日
     * @return 自オブジェクト
     */
    public DDay withEndingDDay(String endingDDay) {
        setEndingDDay(endingDDay);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[startingDDay=");
        builder.append(startingDDay);

        builder.append(", endingDDay=");
        builder.append(endingDDay);

        builder.append("]");

        return builder.toString();

    }

}
