/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 取得したオートスケール情報を保持するクラス。<br />
 * このクラスは取得したオートスケール情報を格納します。
 */
public class AutoScalingReservationSet {

    /** オートスケール名 */
    private String autoScalingGroupName;

    /** メモ */
    private String description;

    /** イメージID */
    private String imageId;

    /** サーバータイプ */
    private String instanceType;

    /** ファイアウォール情報セット */
    private List<GroupSet> groupSet;

    /** トリガー情報セット */
    private List<TriggerSet> triggerSet;

    /** スケールアウトの条件 */
    private String scaleoutCondition;

    /** ロードバランサー情報セット */
    private List<LoadBalancers> loadBalancers;

    /** スケールアウトするサーバーの最小台数 */
    private Integer minSize;

    /** スケールアウトするサーバーの最大台数 */
    private Integer maxSize;

    /** スケールアウトサーバーの有効時間（秒） */
    private Integer instanceLifecycleLimit;

    /** スケールアウト開始間隔（秒） */
    private Integer scaleout;

    /** 縮退開始間隔（秒） */
    private Integer defaultCooldown;

    /** スケールアウト/縮退台数 */
    private Integer changeInCapacity;

    /** スケジュール情報セット */
    private List<ScalingSchedule> scalingSchedule;

    /** ゾーン情報 */
    private PlacementSet placementSet;

    /** スケールアウトサーバー情報セット */
    private List<AutoScalingInstancesSet> autoScalingInstancesSet;

    /** オートスケール設定の作成日時 */
    private String createdTime;

    /** アラーム状態 */
    private String alarm;

    /**
     * オートスケール名を取得します。
     * 
     * @return オートスケール名
     */
    public String getAutoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * オートスケール名を設定します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     */
    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    /**
     * オートスケール名を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingGroupName
     *            オートスケール名
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withAutoScalingGroupName(String autoScalingGroupName) {
        setAutoScalingGroupName(autoScalingGroupName);
        return this;
    }

    /**
     * メモを取得します。
     * 
     * @return メモ
     */
    public String getDescription() {
        return description;
    }

    /**
     * メモを設定します。
     * 
     * @param description
     *            メモ
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモを設定し、自オブジェクトを返します。
     * 
     * @param description
     *            メモ
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * イメージIDを取得します。
     * 
     * @return イメージID
     */
    public String getImageId() {
        return imageId;
    }

    /**
     * イメージIDを設定します。
     * 
     * @param imageId
     *            イメージID
     */
    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    /**
     * イメージIDを設定し、自オブジェクトを返します。
     * 
     * @param imageId
     *            イメージID
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withImageId(String imageId) {
        setImageId(imageId);
        return this;
    }

    /**
     * サーバータイプを取得します。
     * 
     * @return サーバータイプ
     */
    public String getInstanceType() {
        return instanceType;
    }

    /**
     * サーバータイプを設定します。
     * 
     * @param instanceType
     *            サーバータイプ
     */
    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    /**
     * サーバータイプを設定し、自オブジェクトを返します。
     * 
     * @param instanceType
     *            サーバータイプ
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withInstanceType(String instanceType) {
        setInstanceType(instanceType);
        return this;
    }

    /**
     * ファイアウォール情報セットを取得します。
     * 
     * @return ファイアウォール情報セット
     */
    public List<GroupSet> getGroupSet() {
        return groupSet;
    }

    /**
     * ファイアウォール情報セットを設定します。
     * 
     * @param groupSet
     *            ファイアウォール情報セット
     */
    public void setGroupSet(List<GroupSet> groupSet) {
        this.groupSet = groupSet;
    }

    /**
     * ファイアウォール情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param groupSet
     *            ファイアウォール情報セットの配列
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withGroupSet(GroupSet... groupSet) {

        if (this.groupSet == null) {
            this.groupSet = new ArrayList<GroupSet>();
        }

        for (GroupSet work : groupSet) {
            getGroupSet().add(work);
        }

        return this;
    }

    /**
     * ファイアウォール情報セットを設定し、自オブジェクトを返します。
     * 
     * @param groupSet
     *            ファイアウォール情報セット
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withGroupSet(Collection<GroupSet> groupSet) {

        if (this.groupSet == null) {
            this.groupSet = new ArrayList<GroupSet>();
        }

        getGroupSet().addAll(groupSet);

        return this;
    }

    /**
     * トリガー情報セットを取得します。
     * 
     * @return トリガー情報セット
     */
    public List<TriggerSet> getTriggerSet() {
        return triggerSet;
    }

    /**
     * トリガー情報セットを設定します。
     * 
     * @param triggerSet
     *            トリガー情報セット
     */
    public void setTriggerSet(List<TriggerSet> triggerSet) {
        this.triggerSet = triggerSet;
    }

    /**
     * トリガー情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param triggerSet
     *            トリガー情報セットの配列
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withTriggerSet(TriggerSet... triggerSet) {

        if (this.triggerSet == null) {
            this.triggerSet = new ArrayList<TriggerSet>();
        }

        for (TriggerSet work : triggerSet) {
            getTriggerSet().add(work);
        }

        return this;
    }

    /**
     * トリガー情報セットを設定し、自オブジェクトを返します。
     * 
     * @param triggerSet
     *            トリガー情報セット
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withTriggerSet(Collection<TriggerSet> triggerSet) {

        if (this.triggerSet == null) {
            this.triggerSet = new ArrayList<TriggerSet>();
        }

        getTriggerSet().addAll(triggerSet);

        return this;
    }

    /**
     * スケールアウトの条件を取得します。
     * 
     * @return スケールアウトの条件
     */
    public String getScaleoutCondition() {
        return scaleoutCondition;
    }

    /**
     * スケールアウトの条件を設定します。
     * 
     * @param scaleoutCondition
     *            スケールアウトの条件
     */
    public void setScaleoutCondition(String scaleoutCondition) {
        this.scaleoutCondition = scaleoutCondition;
    }

    /**
     * スケールアウトの条件を設定し、自オブジェクトを返します。
     * 
     * @param scaleoutCondition
     *            スケールアウトの条件
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withScaleoutCondition(String scaleoutCondition) {
        setScaleoutCondition(scaleoutCondition);
        return this;
    }

    /**
     * ロードバランサー情報セットを取得します。
     * 
     * @return ロードバランサー情報セット
     */
    public List<LoadBalancers> getLoadBalancers() {
        return loadBalancers;
    }

    /**
     * ロードバランサー情報セットを設定します。
     * 
     * @param loadBalancers
     *            ロードバランサー情報セット
     */
    public void setLoadBalancers(List<LoadBalancers> loadBalancers) {
        this.loadBalancers = loadBalancers;
    }

    /**
     * ロードバランサー情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param loadBalancers
     *            ロードバランサー情報セットの配列
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet
        withLoadBalancers(LoadBalancers... loadBalancers) {

        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList<LoadBalancers>();
        }

        for (LoadBalancers work : loadBalancers) {
            getLoadBalancers().add(work);
        }

        return this;
    }

    /**
     * ロードバランサー情報セットを設定し、自オブジェクトを返します。
     * 
     * @param loadBalancers
     *            ロードバランサー情報セット
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet
        withLoadBalancers(Collection<LoadBalancers> loadBalancers) {

        if (this.loadBalancers == null) {
            this.loadBalancers = new ArrayList<LoadBalancers>();
        }

        this.loadBalancers.addAll(loadBalancers);

        return this;
    }

    /**
     * スケールアウトするサーバーの最小台数を取得します。
     * 
     * @return スケールアウトするサーバーの最小台数
     */
    public Integer getMinSize() {
        return minSize;
    }

    /**
     * スケールアウトするサーバーの最小台数を設定します。
     * 
     * @param minSize
     *            スケールアウトするサーバーの最小台数
     */
    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    /**
     * スケールアウトするサーバーの最小台数を設定し、自オブジェクトを返します。
     * 
     * @param minSize
     *            スケールアウトするサーバーの最小台数
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withMinSize(Integer minSize) {
        setMinSize(minSize);
        return this;
    }

    /**
     * スケールアウトするサーバーの最大台数を取得します。
     * 
     * @return スケールアウトするサーバーの最大台数
     */
    public Integer getMaxSize() {
        return maxSize;
    }

    /**
     * スケールアウトするサーバーの最大台数を設定します。
     * 
     * @param maxSize
     *            スケールアウトするサーバーの最大台数
     */
    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    /**
     * スケールアウトするサーバーの最大台数を設定し、自オブジェクトを返します。
     * 
     * @param maxSize
     *            スケールアウトするサーバーの最大台数
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withMaxSize(Integer maxSize) {
        setMaxSize(maxSize);
        return this;
    }

    /**
     * スケールアウトサーバーの有効時間（秒）を取得します。
     * 
     * @return スケールアウトサーバーの有効時間（秒）
     */
    public Integer getInstanceLifecycleLimit() {
        return instanceLifecycleLimit;
    }

    /**
     * スケールアウトサーバーの有効時間（秒）を設定します。
     * 
     * @param instanceLifecycleLimit
     *            スケールアウトサーバーの有効時間（秒）
     */
    public void setInstanceLifecycleLimit(Integer instanceLifecycleLimit) {
        this.instanceLifecycleLimit = instanceLifecycleLimit;
    }

    /**
     * スケールアウトサーバーの有効時間（秒）を設定し、自オブジェクトを返します。
     * 
     * @param instanceLifecycleLimit
     *            スケールアウトサーバーの有効時間（秒）
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withInstanceLifecycleLimit(Integer instanceLifecycleLimit) {
        setInstanceLifecycleLimit(instanceLifecycleLimit);
        return this;
    }

    /**
     * スケールアウト開始間隔（秒）を取得します。
     * 
     * @return スケールアウト開始間隔（秒）
     */
    public Integer getScaleout() {
        return scaleout;
    }

    /**
     * スケールアウト開始間隔（秒）を設定します。
     * 
     * @param scaleout
     *            スケールアウト開始間隔（秒）
     */
    public void setScaleout(Integer scaleout) {
        this.scaleout = scaleout;
    }

    /**
     * スケールアウト開始間隔（秒）を設定し、自オブジェクトを返します。
     * 
     * @param scaleout
     *            スケールアウト開始間隔（秒）
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withScaleout(Integer scaleout) {
        setScaleout(scaleout);
        return this;
    }

    /**
     * 縮退開始間隔（秒）を取得します。
     * 
     * @return 縮退開始間隔（秒）
     */
    public Integer getDefaultCooldown() {
        return defaultCooldown;
    }

    /**
     * 縮退開始間隔（秒）を設定します。
     * 
     * @param defaultCooldown
     *            縮退開始間隔（秒）
     */
    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    /**
     * 縮退開始間隔（秒）を設定し、自オブジェクトを返します。
     * 
     * @param defaultCooldown
     *            縮退開始間隔（秒）
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withDefaultCooldown(Integer defaultCooldown) {
        setDefaultCooldown(defaultCooldown);
        return this;
    }

    /**
     * スケールアウト/縮退台数を取得します。
     * 
     * @return スケールアウト/縮退台数
     */
    public Integer getChangeInCapacity() {
        return changeInCapacity;
    }

    /**
     * スケールアウト/縮退台数を設定します。
     * 
     * @param changeInCapacity
     *            スケールアウト/縮退台数
     */
    public void setChangeInCapacity(Integer changeInCapacity) {
        this.changeInCapacity = changeInCapacity;
    }

    /**
     * スケールアウト/縮退台数を設定し、自オブジェクトを返します。
     * 
     * @param changeInCapacity
     *            スケールアウト/縮退台数
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withChangeInCapacity(Integer changeInCapacity) {
        setChangeInCapacity(changeInCapacity);
        return this;
    }

    /**
     * スケジュール情報セットを取得します。
     * 
     * @return スケジュール情報セット
     */
    public List<ScalingSchedule> getScalingSchedule() {
        return scalingSchedule;
    }

    /**
     * スケジュール情報セットを設定します。
     * 
     * @param scalingSchedule
     *            スケジュール情報セット
     */
    public void setScalingSchedule(List<ScalingSchedule> scalingSchedule) {
        this.scalingSchedule = scalingSchedule;
    }

    /**
     * スケジュール情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param scalingSchedule
     *            スケジュール情報セットの配列
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withScalingSchedule(ScalingSchedule... scalingSchedule) {

        if (this.scalingSchedule == null) {
            this.scalingSchedule = new ArrayList<ScalingSchedule>();
        }

        for (ScalingSchedule work : scalingSchedule) {
            getScalingSchedule().add(work);
        }

        return this;
    }

    /**
     * スケジュール情報セットを設定し、自オブジェクトを返します。
     * 
     * @param scalingSchedule
     *            スケジュール情報セット
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet
        withScalingSchedule(Collection<ScalingSchedule> scalingSchedule) {

        if (this.scalingSchedule == null) {
            this.scalingSchedule = new ArrayList<ScalingSchedule>();
        }

        getScalingSchedule().addAll(scalingSchedule);

        return this;
    }

    /**
     * ゾーン情報を取得します。
     * 
     * @return ゾーン情報
     */
    public PlacementSet getPlacementSet() {
        return placementSet;
    }

    /**
     * ゾーン情報を設定します。
     * 
     * @param placementSet
     *            ゾーン情報
     */
    public void setPlacementSet(PlacementSet placementSet) {
        this.placementSet = placementSet;
    }

    /**
     * ゾーン情報を設定し、自オブジェクトを返します。
     * 
     * @param placementSet
     *            ゾーン情報
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withPlacementSet(PlacementSet placementSet) {
        setPlacementSet(placementSet);
        return this;
    }

    /**
     * スケールアウトサーバー情報セットを取得します。
     * 
     * @return スケールアウトサーバー情報セット
     */
    public List<AutoScalingInstancesSet> getAutoScalingInstancesSet() {
        return autoScalingInstancesSet;
    }

    /**
     * スケールアウトサーバー情報セットを設定します。
     * 
     * @param autoScalingInstancesSet
     *            スケールアウトサーバー情報セット
     */
    public void setAutoScalingInstancesSet(List<AutoScalingInstancesSet> autoScalingInstancesSet) {
        this.autoScalingInstancesSet = autoScalingInstancesSet;
    }

    /**
     * スケールアウトサーバー情報セットの配列を設定し、自オブジェクトを返します。
     * 
     * @param autoScalingInstancesSet
     *            スケールアウトサーバー情報セットの配列
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet
        withAutoScalingInstancesSet(AutoScalingInstancesSet... autoScalingInstancesSet) {

        if (this.autoScalingInstancesSet == null) {
            this.autoScalingInstancesSet = new ArrayList<AutoScalingInstancesSet>();
        }

        for (AutoScalingInstancesSet work : autoScalingInstancesSet) {
            getAutoScalingInstancesSet().add(work);
        }

        return this;
    }

    /**
     * スケールアウトサーバー情報セットを設定し、自オブジェクトを返します。
     * 
     * @param autoScalingInstancesSet
     *            スケールアウトサーバー情報セット
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet
        withAutoScalingInstancesSet(Collection<AutoScalingInstancesSet> autoScalingInstancesSet) {

        if (this.autoScalingInstancesSet == null) {
            this.autoScalingInstancesSet = new ArrayList<AutoScalingInstancesSet>();
        }

        getAutoScalingInstancesSet().addAll(autoScalingInstancesSet);

        return this;
    }

    /**
     * オートスケール設定の作成日時を取得します。
     * 
     * @return オートスケール設定の作成日時
     */
    public String getCreatedTime() {
        return createdTime;
    }

    /**
     * オートスケール設定の作成日時を設定します。
     * 
     * @param createdTime
     *            オートスケール設定の作成日時
     */
    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * オートスケール設定の作成日時を設定し、自オブジェクトを返します。
     * 
     * @param createdTime
     *            オートスケール設定の作成日時
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withCreatedTime(String createdTime) {
        setCreatedTime(createdTime);
        return this;
    }

    /**
     * アラーム状態を取得します。
     * 
     * @return アラーム状態
     */
    public String getAlarm() {
        return alarm;
    }

    /**
     * アラーム状態を設定します。
     * 
     * @param alarm
     *            アラーム状態
     */
    public void setAlarm(String alarm) {
        this.alarm = alarm;
    }

    /**
     * アラーム状態を設定し、自オブジェクトを返します。
     * 
     * @param alarm
     *            アラーム状態
     * @return 自オブジェクト
     */
    public AutoScalingReservationSet withAlarm(String alarm) {
        setAlarm(alarm);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[autoScalingGroupName=");
        builder.append(autoScalingGroupName);

        builder.append(", description=");
        builder.append(description);

        builder.append(", imageId=");
        builder.append(imageId);

        builder.append(", instanceType=");
        builder.append(instanceType);

        builder.append(", groupSet=");
        builder.append(groupSet);

        builder.append(", triggerSet=");
        builder.append(triggerSet);

        builder.append(", scaleoutCondition=");
        builder.append(scaleoutCondition);

        builder.append(", loadBalancers=");
        builder.append(loadBalancers);

        builder.append(", minSize=");
        builder.append(minSize);

        builder.append(", maxSize=");
        builder.append(maxSize);

        builder.append(", instanceLifecycleLimit=");
        builder.append(instanceLifecycleLimit);

        builder.append(", scaleout=");
        builder.append(scaleout);

        builder.append(", defaultCooldown=");
        builder.append(defaultCooldown);

        builder.append(", changeInCapacity=");
        builder.append(changeInCapacity);

        builder.append(", scalingSchedule=");
        builder.append(scalingSchedule);

        builder.append(", placementSet=");
        builder.append(placementSet);

        builder.append(", autoScalingInstancesSet=");
        builder.append(autoScalingInstancesSet);

        builder.append(", createdTime=");
        builder.append(createdTime);

        builder.append(", alarm=");
        builder.append(alarm);

        builder.append("]");

        return builder.toString();

    }

}
