/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale.model;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * スケールアウトサーバーの情報を保持するクラス。<br />
 * このクラスはスケールアウトサーバー情報アイテムを格納します。
 */
@XStreamAlias("AutoScalingInstancesSet")
public class AutoScalingInstancesSet {

    /** サーバー名 */
    private String instanceId;

    /** サーバーのユニークID */
    private String instanceUniqueId;

    /** サーバーステータス */
    private InstanceState instanceState;

    /** グローバルIPアドレス */
    private String dnsName;

    /** サーバータイプ */
    private String instanceType;

    /** 有効時間 */
    private String expireTime;

    /**
     * サーバー名を取得します。
     * 
     * @return サーバー名
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * サーバー名を設定します。
     * 
     * @param instanceId
     *            サーバー名
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * サーバー名を設定し、自オブジェクトを返します。
     * 
     * @param instanceId
     *            サーバー名
     * @return 自オブジェクト
     */
    public AutoScalingInstancesSet withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * サーバーのユニークIDを取得します。
     * 
     * @return サーバーのユニークID
     */
    public String getInstanceUniqueId() {
        return instanceUniqueId;
    }

    /**
     * サーバーのユニークIDを設定します。
     * 
     * @param instanceUniqueId
     *            サーバーのユニークID
     */
    public void setInstanceUniqueId(String instanceUniqueId) {
        this.instanceUniqueId = instanceUniqueId;
    }

    /**
     * サーバーのユニークIDを設定し、自オブジェクトを返します。
     * 
     * @param instanceUniqueId
     *            サーバーのユニークID
     * @return 自オブジェクト
     */
    public AutoScalingInstancesSet withInstanceUniqueId(String instanceUniqueId) {
        setInstanceUniqueId(instanceUniqueId);
        return this;
    }

    /**
     * サーバーステータスを取得します。
     * 
     * @return サーバーステータス
     */
    public InstanceState getInstanceState() {
        return instanceState;
    }

    /**
     * サーバーステータスを設定します。
     * 
     * @param instanceState
     *            サーバーステータス
     */
    public void setInstanceState(InstanceState instanceState) {
        this.instanceState = instanceState;
    }

    /**
     * サーバーステータスを設定し、自オブジェクトを返します。
     * 
     * @param instanceState
     *            サーバーステータス
     * @return 自オブジェクト
     */
    public AutoScalingInstancesSet withInstanceState(InstanceState instanceState) {
        setInstanceState(instanceState);
        return this;
    }

    /**
     * グローバルIPアドレスを取得します。
     * 
     * @return グローバルIPアドレス
     */
    public String getDnsName() {
        return dnsName;
    }

    /**
     * グローバルIPアドレスを設定します。
     * 
     * @param dnsName
     *            グローバルIPアドレス
     */
    public void setDnsName(String dnsName) {
        this.dnsName = dnsName;
    }

    /**
     * グローバルIPアドレスを設定し、自オブジェクトを返します。
     * 
     * @param dnsName
     *            グローバルIPアドレス
     * @return 自オブジェクト
     */
    public AutoScalingInstancesSet withDnsName(String dnsName) {
        setDnsName(dnsName);
        return this;
    }

    /**
     * サーバータイプを取得します。
     * 
     * @return サーバータイプ
     */
    public String getInstanceType() {
        return instanceType;
    }

    /**
     * サーバータイプを設定します。
     * 
     * @param instanceType
     *            サーバータイプ
     */
    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    /**
     * サーバータイプを設定し、自オブジェクトを返します。
     * 
     * @param instanceType
     *            サーバータイプ
     * @return 自オブジェクト
     */
    public AutoScalingInstancesSet withInstanceType(String instanceType) {
        setInstanceType(instanceType);
        return this;
    }

    /**
     * 有効時間を取得します。
     * 
     * @return 有効時間
     */
    public String getExpireTime() {
        return expireTime;
    }

    /**
     * 有効時間を設定します。
     * 
     * @param expireTime
     *            有効時間
     */
    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    /**
     * 有効時間を設定し、自オブジェクトを返します。
     * 
     * @param expireTime
     *            有効時間
     * @return 自オブジェクト
     */
    public AutoScalingInstancesSet withExpireTime(String expireTime) {
        setExpireTime(expireTime);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        StringBuilder builder = new StringBuilder();

        builder.append("[instanceId=");
        builder.append(instanceId);

        builder.append(", instanceUniqueId=");
        builder.append(instanceUniqueId);

        builder.append(", instanceState=");
        builder.append(instanceState);

        builder.append(", dnsName=");
        builder.append(dnsName);

        builder.append(", instanceType=");
        builder.append(instanceType);

        builder.append(", expireTime=");
        builder.append(expireTime);

        builder.append("]");

        return builder.toString();

    }

}
