/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.auth.Credentials;
import com.nifty.cloud.sdk.autoscale.model.NiftyCreateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyCreateAutoScalingGroupResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDeleteAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDeleteAutoScalingGroupResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupResult;

/**
 * NIFCLOUD API クライアント 具象クラス。 オートスケール カテゴリ クライアント。<br />
 * オートスケール カテゴリの同期クライアントの具象クラスです。
 *
 */
public class NiftyAutoScaleClient extends BaseClient implements NiftyAutoScale {

    /**
     * 認証情報を指定し、オートスケールカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     */
    public NiftyAutoScaleClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    /**
     * 認証情報、クライアント設定を指定し、オートスケールカテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftyAutoScaleClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyCreateAutoScalingGroupResult
        niftyCreateAutoScalingGroup(NiftyCreateAutoScalingGroupRequest request) {
        return (NiftyCreateAutoScalingGroupResult) client.execute(request,
            NiftyCreateAutoScalingGroupResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeAutoScalingGroupsResult niftyDescribeAutoScalingGroups(
        NiftyDescribeAutoScalingGroupsRequest request) {
        return (NiftyDescribeAutoScalingGroupsResult) client.execute(request,
            NiftyDescribeAutoScalingGroupsResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeScalingActivitiesResult niftyDescribeScalingActivities(
        NiftyDescribeScalingActivitiesRequest request) {
        return (NiftyDescribeScalingActivitiesResult) client.execute(request,
            NiftyDescribeScalingActivitiesResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyUpdateAutoScalingGroupResult
        niftyUpdateAutoScalingGroup(NiftyUpdateAutoScalingGroupRequest request) {
        return (NiftyUpdateAutoScalingGroupResult) client.execute(request,
            NiftyUpdateAutoScalingGroupResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDeleteAutoScalingGroupResult
        niftyDeleteAutoScalingGroup(NiftyDeleteAutoScalingGroupRequest request) {
        return (NiftyDeleteAutoScalingGroupResult) client.execute(request,
            NiftyDeleteAutoScalingGroupResult.class);
    }

}
