/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.autoscale.model.NiftyCreateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyCreateAutoScalingGroupResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDeleteAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDeleteAutoScalingGroupResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupResult;

/**
 * NIFCLOUD API 非同期クライアント インタフェース。 オートスケール カテゴリクライアント。<br />
 * オートスケール カテゴリの非同期クライアントのインタフェースです。
 *
 */
public interface NiftyAutoScaleAsync extends NiftyAutoScale {

    /**
     * 非同期でオートスケール定義を新規作成します。
     *
     * @param request
     *            NiftyCreateAutoScalingGroupリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyCreateAutoScalingGroupResult>
        niftyCreateAutoCallingGroupAsync(NiftyCreateAutoScalingGroupRequest request);

    /**
     * 非同期で指定したオートスケールの定義情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAutoScalingGroupsリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeAutoScalingGroupsResult>
        niftyDescribeAutoScalingGroupsAsync(NiftyDescribeAutoScalingGroupsRequest request);

    /**
     * 非同期で指定したオートスケール定義のログを取得します。
     * 
     * @param request
     *            NiftyDescribeScalingActivitiesリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeScalingActivitiesResult>
        niftyDescribeScalingActivitiesAsync(NiftyDescribeScalingActivitiesRequest request);

    /**
     * 非同期で指定したオートスケールの定義を変更します。
     * 
     * @param request
     *            NiftyUpdateAutoScalingGroupリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyUpdateAutoScalingGroupResult>
        niftyUpdateAutoScalingGroupAsync(NiftyUpdateAutoScalingGroupRequest request);

    /**
     * 非同期で指定したオートスケールの定義を削除します。
     * 
     * @param request
     *            NiftyDeleteAutoScalingGroupGroupリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDeleteAutoScalingGroupResult>
        niftyDeleteAutoScalingGroupAsync(NiftyDeleteAutoScalingGroupRequest request);

}
