/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.autoscale;

import com.nifty.cloud.sdk.autoscale.model.NiftyCreateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyCreateAutoScalingGroupResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDeleteAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDeleteAutoScalingGroupResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeAutoScalingGroupsResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyDescribeScalingActivitiesResult;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupRequest;
import com.nifty.cloud.sdk.autoscale.model.NiftyUpdateAutoScalingGroupResult;

/**
 * NIFCLOUD API クライアント インタフェース。 オートスケール カテゴリ クライアント。<br />
 * オートスケール カテゴリの同期クライアントのインタフェースです。
 *
 */
public interface NiftyAutoScale {

    /**
     * エンドポイントの設定を行います。
     *
     * @param endpoint
     *            エンドポイント
     */
    public void setEndpoint(String endpoint);

    /**
     * オートスケール定義を新規作成します。
     * 
     * @param request
     *            NiftyCreateAutoScalingGroupリクエスト
     * @return NiftyCreateAutoScalingGroup処理結果
     */
    public NiftyCreateAutoScalingGroupResult
        niftyCreateAutoScalingGroup(NiftyCreateAutoScalingGroupRequest request);

    /**
     * 指定したオートスケールの定義情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAutoScalingGroupsリクエスト
     * @return NiftyDescribeAutoScalingGroups処理結果
     */
    public NiftyDescribeAutoScalingGroupsResult
        niftyDescribeAutoScalingGroups(NiftyDescribeAutoScalingGroupsRequest request);

    /**
     * 指定したオートスケール定義のログを取得します。
     * 
     * @param request
     *            NiftyDescribeScalingActivitiesリクエスト
     * @return NiftyDescribeScalingActivities処理結果
     */
    public NiftyDescribeScalingActivitiesResult
        niftyDescribeScalingActivities(NiftyDescribeScalingActivitiesRequest request);

    /**
     * 指定したオートスケールの定義を変更します。
     * 
     * @param request
     *            NiftyUpdateAutoScalingGroupリクエスト
     * @return NiftyUpdateAutoScalingGroup処理結果
     */
    public NiftyUpdateAutoScalingGroupResult
        niftyUpdateAutoScalingGroup(NiftyUpdateAutoScalingGroupRequest request);

    /**
     * 指定したオートスケールの定義を削除します。
     * 
     * @param request
     *            NiftyDeleteAutoScalingGroupリクエスト
     * @return NiftyDeleteAutoScalingGroup処理結果
     */
    public NiftyDeleteAutoScalingGroupResult
        niftyDeleteAutoScalingGroup(NiftyDeleteAutoScalingGroupRequest request);

}
