/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesReservationSet;
import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * AlarmRulesActivitiesReservationSetType変換クラス。<br />
 * このクラスはレスポンスXMLのreservationSet要素からAlarmRulesActivitiesReservationSetクラスを生成します。
 */
public class AlarmRulesActivitiesReservationSetConverter implements Converter {

    private static final String ELEMENT_RULE_NAME = "ruleName";
    private static final String ELEMENT_FUNCTION_NAME = "functionName";
    private static final String ELEMENT_ALARM_RULES_ACTIVITIES_SET = "alarmRulesActivitiesSet";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        for (Class i : clazz.getInterfaces()) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }
    /**
     * {@literal
     * reservationSetをList<AlarmRulesActivitiesReservationSet>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<AlarmRulesActivitiesReservationSet>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {

        List<AlarmRulesActivitiesReservationSet> alarmRulesActivitiesReservationSets =
            new ArrayList<AlarmRulesActivitiesReservationSet>();

        Converter alarmRulesActivitiesSetConvter = new AlarmRulesActivitiesSetConverter();

        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            AlarmRulesActivitiesReservationSet alarmRulesActivitiesReservationSet = new AlarmRulesActivitiesReservationSet();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_RULE_NAME)) {
                    alarmRulesActivitiesReservationSet.setRuleName(reader.getValue());
                } else if (name.equals(ELEMENT_FUNCTION_NAME)) {
                    alarmRulesActivitiesReservationSet.setFunctionName(reader.getValue());
                } else if (name.equals(ELEMENT_ALARM_RULES_ACTIVITIES_SET)) {
                    alarmRulesActivitiesReservationSet.setAlarmRulesActivitiesSets((List<AlarmRulesActivitiesSet>) alarmRulesActivitiesSetConvter
                            .unmarshal(reader, context));
                }
                reader.moveUp();
            }
            reader.moveUp();
            alarmRulesActivitiesReservationSets.add(alarmRulesActivitiesReservationSet);
        }

        return alarmRulesActivitiesReservationSets;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {
        
        // 処理無し
    }

}
