/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesEventSet;
import com.nifty.cloud.sdk.tools.DateUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * AlarmRulesActivitiesEventSetType変換クラス。<br />
 * このクラスはレスポンスXMLのalarmRulesActivitiesEventSet要素からAlarmRulesActivitiesEventSetクラスのリストを生成します。
 */
public class AlarmRulesActivitiesEventSetConverter implements Converter {

    private static final String ELEMENT_ALARM_RULES_ACTIVITIES_EVENT_DATETIME =
        "alarmRulesActivitiesEventDatetime";
    private static final String ELEMENT_ALARM_RULES_ACTIVITIES_EVENT = "alarmRulesActivitiesEvent";
    private static final String ELEMENT_RESOURCE_NAME = "resourceName";
    private static final String ELEMENT_VALUE = "value";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * alarmRulesActivitiesEventSet要素をList<AlarmRulesActivitiesEventSet>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<AlarmRulesActivitiesEventSet>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<AlarmRulesActivitiesEventSet> alarmRulesActivitiesEventSets =
            new ArrayList<AlarmRulesActivitiesEventSet>();

        String name = null;
        while (reader.hasMoreChildren()) {

            reader.moveDown();
            AlarmRulesActivitiesEventSet alarmRulesActivitiesEventSet =
                new AlarmRulesActivitiesEventSet();

            while (reader.hasMoreChildren()) {
                reader.moveDown();

                name = reader.getNodeName();
                if (name.equals(ELEMENT_ALARM_RULES_ACTIVITIES_EVENT_DATETIME)) {
                    alarmRulesActivitiesEventSet
                        .setAlarmRulesActivitiesEventDatetime(DateUtils.toDate(reader.getValue()));
                } else if (name.equals(ELEMENT_ALARM_RULES_ACTIVITIES_EVENT)) {
                    alarmRulesActivitiesEventSet.setAlarmRulesActivitiesEvent(reader.getValue());
                } else if (name.equals(ELEMENT_RESOURCE_NAME)) {
                    alarmRulesActivitiesEventSet.setResourceName(reader.getValue());
                } else if (name.equals(ELEMENT_VALUE)) {
                    alarmRulesActivitiesEventSet.setValue(reader.getValue());
                }
                reader.moveUp();
            }

            reader.moveUp();
            alarmRulesActivitiesEventSets.add(alarmRulesActivitiesEventSet);
        }

        return alarmRulesActivitiesEventSets;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {
        // 処理無し
    }

}
