/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesDateSet;
import com.nifty.cloud.sdk.alarm.model.AlarmRulesActivitiesEventSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * AlarmRulesActivitiesDateSetType変換クラス。<br />
 * このクラスはレスポンスXMLのalarmRulesActivitiesDateSet要素からAlarmRulesActivitiesDateSetクラスのリストを生成します。
 */
public class AlarmRulesActivitiesDateSetConverter implements Converter {
    private static final String ELEMENT_DATE = "date";
    private static final String ELEMENT_ALARM_RULES_ACTIVITIES_EVENT_SET =
        "alarmRulesActivitiesEventSet";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * alarmRulesActivitiesDateSet要素をList<AlarmRulesActivitiesDateSet>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<AlarmRulesActivitiesDateSet>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<AlarmRulesActivitiesDateSet> alarmRulesActivitiesDateSets =
            new ArrayList<AlarmRulesActivitiesDateSet>();
        Converter alarmRulesActivitiesEventSetConverter =
            new AlarmRulesActivitiesEventSetConverter();

        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            AlarmRulesActivitiesDateSet alarmRulesActivitiesDateSet =
                new AlarmRulesActivitiesDateSet();

            while (reader.hasMoreChildren()) {
                reader.moveDown();

                name = reader.getNodeName();
                if (name.equals(ELEMENT_DATE)) {
                    alarmRulesActivitiesDateSet.setDate(reader.getValue());
                } else if (name.equals(ELEMENT_ALARM_RULES_ACTIVITIES_EVENT_SET)) {
                    alarmRulesActivitiesDateSet.setAlarmRulesActivitiesEvents(
                        (List<AlarmRulesActivitiesEventSet>) alarmRulesActivitiesEventSetConverter
                            .unmarshal(reader, context));
                }
                reader.moveUp();
            }

            reader.moveUp();
            alarmRulesActivitiesDateSets.add(alarmRulesActivitiesDateSet);
        }

        return alarmRulesActivitiesDateSets;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {

        // 処理無し
    }

}
