/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model.transform;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.alarm.model.AlarmDateHistorySet;
import com.nifty.cloud.sdk.alarm.model.AlarmReservationSet;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

/**
 * AlarmReservationSetType変換クラス。<br />
 * このクラスはレスポンスXMLのreservationSet要素からAlarmReservationSetクラスのリストを生成します。
 */
public class AlarmReservationSetConverter implements Converter {

    private static final String ELEMENT_RULE_NAME = "ruleName";
    private static final String ELEMENT_FUNCTION_NAME = "functionName";
    private static final String ELEMENT_ALARM_DATE_HISTORY_SET = "alarmDateHistorySet";

    /**
     * 変換可能なクラスか判定します。
     *
     * @param clazz
     *            クラス
     * @return 変換可能な場合true, 変換不可能な場合false
     *
     * @see com.thoughtworks.xstream.converters.Converter#canConvert(Class)
     */
    @SuppressWarnings("rawtypes")
    @Override
    public boolean canConvert(Class clazz) {
        Class[] interfaces = clazz.getInterfaces();
        for (Class i : interfaces) {
            if (i == List.class) {
                return true;
            }
        }
        return false;
    }

    /**
     * {@literal
     * reservationSet要素をList<AlarmReservationSet>クラスに変換します。}
     *
     * @param reader
     *            XML読込リーダ
     * @param context
     * @return {@literal List<AlarmReservationSet>オブジェクト}
     *
     * @see com.thoughtworks.xstream.converters.Converter#unmarshal(HierarchicalStreamReader,
     *      UnmarshallingContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        List<AlarmReservationSet> reservationSets = new ArrayList<AlarmReservationSet>();
        Converter alarmDateHistorySetConverter = new AlarmDateHistorySetConverter();
        String name = null;

        while (reader.hasMoreChildren()) {
            reader.moveDown();
            AlarmReservationSet alarmReservationSet = new AlarmReservationSet();
            while (reader.hasMoreChildren()) {
                reader.moveDown();

                name = reader.getNodeName();
                if (name.equals(ELEMENT_RULE_NAME)) {
                    alarmReservationSet.setRuleName(reader.getValue());
                } else if (name.equals(ELEMENT_FUNCTION_NAME)) {
                    alarmReservationSet.setFunctionName(reader.getValue());
                } else if (name.equals(ELEMENT_ALARM_DATE_HISTORY_SET)) {
                    alarmReservationSet.setAlarmDateHistorys(
                        (List<AlarmDateHistorySet>) alarmDateHistorySetConverter.unmarshal(reader,
                            context));
                }

                reader.moveUp();
            }
            reservationSets.add(alarmReservationSet);
            reader.moveUp();
        }

        return reservationSets;
    }

    /**
     * 未実装メソッド
     */
    @Override
    public void marshal(Object paramObject,
        HierarchicalStreamWriter paramHierarchicalStreamWriter,
        MarshallingContext paramMarshallingContext) {

        // 処理無し
    }
}
