/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import com.nifty.cloud.sdk.annotation.Query;

/**
 * RuleCreateクラス。<br />
 * このクラスはRuleCreateを格納します。
 */
public class RuleCreate {

    /** 監視項目 */
    private String dataType;

    /** 閾値 */
    private Double threshold;

    /** 条件 */
    private String upperLowerCondition;

    /** 長さ */
    private Integer breachDuration;

    /**
     * 監視項目を取得します。
     *
     * @return 監視項目
     */
    @Query(name = "DataType", require = true)
    public String getDataType() {
        return dataType;
    }

    /**
     * 監視項目を設定します。
     *
     * @param dataType
     *            監視項目
     */
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    /**
     * 監視項目を設定し、自オブジェクトを返します。
     *
     * @param dataType
     *            監視項目
     * @return 自オブジェクト
     */
    public RuleCreate withDataType(String dataType) {
        setDataType(dataType);
        return this;
    }

    /**
     * 閾値を取得します。
     *
     * @return 閾値
     */
    @Query(name = "Threshold")
    public Double getThreshold() {
        return threshold;
    }

    /**
     * 閾値を設定します。
     *
     * @param threshold
     *            閾値
     * 
     */
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    /**
     * 閾値を設定し、自オブジェクトを返します。
     *
     * @param threshold
     *            閾値
     * 
     * @return 自オブジェクト
     */
    public RuleCreate withThreshold(Double threshold) {
        setThreshold(threshold);
        return this;
    }

    /**
     * 条件を取得します。
     *
     * @return 条件
     */
    @Query(name = "UpperLowerCondition")
    public String getUpperLowerCondition() {
        return upperLowerCondition;
    }

    /**
     * 条件を設定します。
     *
     * @param upperLowerCondition
     *            条件
     */
    public void setUpperLowerCondition(String upperLowerCondition) {
        this.upperLowerCondition = upperLowerCondition;
    }

    /**
     * 条件を設定し、自オブジェクトを返します。
     *
     * @param upperLowerCondition
     *            条件
     * 
     * @return 自オブジェクト
     */
    public RuleCreate withUpperLowerCondition(String upperLowerCondition) {
        setUpperLowerCondition(upperLowerCondition);
        return this;
    }

    /**
     * 長さを取得します。
     *
     * @return 長さ
     */
    @Query(name = "BreachDuration", require = true)
    public Integer getBreachDuration() {
        return breachDuration;
    }

    /**
     * 長さを設定します。
     *
     * @param breachDuration
     *            長さ
     */
    public void setBreachDuration(Integer breachDuration) {
        this.breachDuration = breachDuration;
    }

    /**
     * 長さを設定し、自オブジェクトを返します。
     *
     * @param breachDuration
     *            長さ
     * @return 自オブジェクト
     */
    public RuleCreate withBreachDuration(Integer breachDuration) {
        setBreachDuration(breachDuration);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[dataType=");
        builder.append(dataType);
        builder.append(", threshold=");
        builder.append(threshold);
        builder.append(", upperLowerCondition=");
        builder.append(upperLowerCondition);
        builder.append(", breachDuration=");
        builder.append(breachDuration);
        builder.append("]");
        return builder.toString();
    }
}
