/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

/**
 * PartitionsSet情報クラス。<br />
 * このクラスはPartitionsSet情報を格納します。
 */
public class PartitionsSet {

    /** パーティション名 */
    private String partition;

    /**
     * パーティション名を取得します。
     *
     * @return パーティション名
     */
    public String getPartition() {
        return partition;
    }

    /**
     * パーティション名を設定します。
     *
     * @param partition
     *            パーティション名
     */
    public void setPartition(String partition) {
        this.partition = partition;
    }

    /**
     * パーティション名を設定し、自オブジェクトを返します。
     *
     * @param partition
     *            パーティション名
     * @return 自オブジェクト
     */
    public PartitionsSet withPartition(String partition) {
        setPartition(partition);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[partition=");
        builder.append(partition);
        builder.append("]");
        return builder.toString();
    }
}
