/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyUpdateAlarmリクエストクラス。<br />
 * このクラスはNiftyUpdateAlarmへのリクエストを構築します。
 */
@Action("NiftyUpdateAlarm")
public class NiftyUpdateAlarmRequest implements Request {

    /** 監視ルール名 */
    private String ruleName;

    /** 変更後監視ルール名 */
    private String ruleNameUpdate;

    /** 機能名 */
    private String functionName;

    /** メモ情報 */
    private String description;

    /** サーバー名リスト */
    private List<String> instanceIds;

    /** ロードバランサー名リスト */
    private List<String> loadBalancerNames;

    /** 待ち受けポートリスト */
    private List<String> loadBalancerPorts;

    /** パーティションリスト */
    private List<String> partitions;

    /** マルチロードバランサー名リスト */
    private List<String> elasticLoadBalancerNames;

    /** マルチロードバランサーのプロトコルリスト */
    private List<String> elasticLoadBalancerProtocols;

    /** マルチロードバランサーの待ち受けポートリスト */
    private List<String> elasticLoadBalancerPorts;

    /** 監視内容リスト */
    private List<RuleUpdate> rules;

    /** 監視通知の条件 */
    private String alarmCondition;

    /** 通知先メールアドレスリスト */
    private List<String> emailAddresses;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyUpdateAlarmRequest() {
    }

    /**
     * 監視ルール名, 機能名を指定し、NiftyUpdateAlarmRequestを構築します。
     *
     * @param ruleName
     *            監視ルール名
     * @param functionName
     *            機能名
     */
    public NiftyUpdateAlarmRequest(String ruleName, String functionName) {
        this.ruleName = ruleName;
        this.functionName = functionName;
    }

    /**
     * 監視ルール名を取得します。
     *
     * @return 監視ルール名
     */
    @Query(name = "RuleName", require = true)
    public String getRuleName() {
        return ruleName;
    }

    /**
     * 監視ルール名を設定します。
     *
     * @param ruleName
     *            監視ルール名
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 監視ルール名を設定し、自オブジェクトを返します。
     *
     * @param ruleName
     *            監視ルール名
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withRuleName(String ruleName) {
        setRuleName(ruleName);
        return this;
    }

    /**
     * 変更後監視ルール名を取得します。
     *
     * @return 変更後監視ルール名
     */
    @Query(name = "RuleNameUpdate")
    public String getRuleNameUpdate() {
        return ruleNameUpdate;
    }

    /**
     * 変更後監視ルール名を設定します。
     *
     * @param ruleNameUpdate
     *            変更後監視ルール名
     */
    public void setRuleNameUpdate(String ruleNameUpdate) {
        this.ruleNameUpdate = ruleNameUpdate;
    }

    /**
     * 変更後監視ルール名を設定し、自オブジェクトを返します。
     *
     * @param ruleNameUpdate
     *            変更後監視ルール名
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withRuleNameUpdate(String ruleNameUpdate) {
        setRuleNameUpdate(ruleNameUpdate);
        return this;
    }

    /**
     * 機能名を取得します。
     *
     * @return 機能名
     */
    @Query(name = "FunctionName", require = true)
    public String getFunctionName() {
        return functionName;
    }

    /**
     * 機能名を設定します。
     *
     * @param functionName
     *            機能名
     */
    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    /**
     * 機能名を設定し、自オブジェクトを返します。
     *
     * @param functionName
     *            機能名
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withFunctionName(String functionName) {
        setFunctionName(functionName);
        return this;
    }

    /**
     * メモ情報を取得します。
     *
     * @return メモ情報
     */
    @Query(name = "Description")
    public String getDescription() {
        return description;
    }

    /**
     * メモ情報を設定します。
     *
     * @param description
     *            メモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモ情報を設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ情報
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * サーバー名リストを取得します。
     *
     * @return サーバー名リスト
     */
    @Query(name = "InstanceId")
    public List<String> getInstanceIds() {
        return instanceIds;
    }

    /**
     * サーバー名リストを設定します。
     *
     * @param instanceIds
     *            サーバー名リスト
     */
    public void setInstanceIds(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    /**
     * サーバー名の配列を設定し、自オブジェクトを返します。
     *
     * @param instanceIds
     *            サーバー名の配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withInstanceIds(
        String... instanceIds) {
        if (this.instanceIds == null)
            this.instanceIds = new ArrayList<String>();
        for (String instanceId : instanceIds) {
            getInstanceIds().add(instanceId);
        }
        return this;
    }

    /**
     * サーバー名リストを設定し、自オブジェクトを返します。
     *
     * @param instanceIds
     *            サーバー名リスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withInstanceIds(
        List<String> instanceIds) {
        if (this.instanceIds == null)
            this.instanceIds = new ArrayList<String>();
        if (instanceIds != null) {
            getInstanceIds().addAll(instanceIds);
        }
        return this;
    }

    /**
     * ロードバランサー名リストを取得します。
     *
     * @return ロードバランサー名リスト
     */
    @Query(name = "LoadBalancerName")
    public List<String> getLoadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * ロードバランサー名リストを設定します。
     *
     * @param loadBalancerNames
     *            ロードバランサー名リスト
     */
    public void setLoadBalancerNames(List<String> loadBalancerNames) {
        this.loadBalancerNames = loadBalancerNames;
    }

    /**
     * ロードバランサー名の配列を設定し、自オブジェクトを返します。
     *
     * @param loadBalancerNames
     *            ロードバランサー名の配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withLoadBalancerNames(
        String... loadBalancerNames) {
        if (this.loadBalancerNames == null)
            this.loadBalancerNames = new ArrayList<String>();
        for (String loadBalancerName : loadBalancerNames) {
            getLoadBalancerNames().add(loadBalancerName);
        }
        return this;
    }

    /**
     * ロードバランサー名リストを設定し、自オブジェクトを返します。
     *
     * @param loadBalancerNames
     *            ロードバランサー名リスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withLoadBalancerNames(
        List<String> loadBalancerNames) {
        if (this.loadBalancerNames == null)
            this.loadBalancerNames = new ArrayList<String>();
        if (loadBalancerNames != null) {
            getLoadBalancerNames().addAll(loadBalancerNames);
        }
        return this;
    }

    /**
     * 待ち受けポートリストを取得します。
     *
     * @return 待ち受けポートリスト
     */
    @Query(name = "LoadBalancerPort")
    public List<String> getLoadBalancerPorts() {
        return loadBalancerPorts;
    }

    /**
     * 待ち受けポートリストを設定します。
     *
     * @param loadBalancerPorts
     *            待ち受けポートリスト
     */
    public void setLoadBalancerPorts(List<String> loadBalancerPorts) {
        this.loadBalancerPorts = loadBalancerPorts;
    }

    /**
     * 待ち受けポートの配列を設定し、自オブジェクトを返します。
     *
     * @param loadBalancerPorts
     *            待ち受けポートの配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withLoadBalancerPorts(
        String... loadBalancerPorts) {
        if (this.loadBalancerPorts == null)
            this.loadBalancerPorts = new ArrayList<String>();
        for (String loadBalancerPort : loadBalancerPorts) {
            getLoadBalancerPorts().add(loadBalancerPort);
        }
        return this;
    }

    /**
     * 待ち受けポートリストを設定し、自オブジェクトを返します。
     *
     * @param loadBalancerPorts
     *            待ち受けポートリスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withLoadBalancerPorts(
        List<String> loadBalancerPorts) {
        if (this.loadBalancerPorts == null)
            this.loadBalancerPorts = new ArrayList<String>();
        if (loadBalancerPorts != null) {
            getLoadBalancerPorts().addAll(loadBalancerPorts);
        }
        return this;
    }

    /**
     * パーティションリストを取得します。
     *
     * @return パーティションリスト
     */
    @Query(name = "Partition")
    public List<String> getPartitions() {
        return partitions;
    }

    /**
     * パーティションリストを設定します。
     *
     * @param partitions
     *            パーティションリスト
     */
    public void setPartitions(List<String> partitions) {
        this.partitions = partitions;
    }

    /**
     * パーティションの配列を設定し、自オブジェクトを返します。
     *
     * @param partitions
     *            パーティションの配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withPartitions(
        String... partitions) {
        if (this.partitions == null)
            this.partitions = new ArrayList<String>();
        for (String partition : partitions) {
            getPartitions().add(partition);
        }
        return this;
    }

    /**
     * パーティションリストを設定し、自オブジェクトを返します。
     *
     * @param partitions
     *            パーティションリスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withPartitions(
        List<String> partitions) {
        if (this.partitions == null)
            this.partitions = new ArrayList<String>();
        if (partitions != null) {
            getPartitions().addAll(partitions);
        }
        return this;
    }

    /**
     * マルチロードバランサー名リストを取得します。
     *
     * @return マルチロードバランサー名リスト
     */
    @Query(name = "ElasticLoadBalancerName")
    public List<String> getElasticLoadBalancerNames() {
        return elasticLoadBalancerNames;
    }

    /**
     * マルチロードバランサー名リストを設定します。
     *
     * @param elasticLoadBalancerNames
     *            マルチロードバランサー名リスト
     */
    public void setElasticLoadBalancerNames(List<String> elasticLoadBalancerNames) {
        this.elasticLoadBalancerNames = elasticLoadBalancerNames;
    }

    /**
     * マルチロードバランサー名の配列を設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerNames
     *            マルチロードバランサー名の配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withElasticLoadBalancerNames(
        String... elasticLoadBalancerNames) {
        if (this.elasticLoadBalancerNames == null)
            this.elasticLoadBalancerNames = new ArrayList<String>();
        for (String elasticLoadBalancerName : elasticLoadBalancerNames) {
            getElasticLoadBalancerNames().add(elasticLoadBalancerName);
        }
        return this;
    }

    /**
     * マルチロードバランサー名リストを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerNames
     *            マルチロードバランサー名リスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withElasticLoadBalancerNames(
        List<String> elasticLoadBalancerNames) {
        if (this.elasticLoadBalancerNames == null)
            this.elasticLoadBalancerNames = new ArrayList<String>();
        if (elasticLoadBalancerNames != null) {
            getElasticLoadBalancerNames().addAll(elasticLoadBalancerNames);
        }
        return this;
    }

    /**
     * マルチロードバランサーのプロトコルリストを取得します。
     *
     * @return マルチロードバランサーのプロトコルリスト
     */
    @Query(name = "ElasticLoadBalancerProtocol")
    public List<String> getElasticLoadBalancerProtocols() {
        return elasticLoadBalancerProtocols;
    }

    /**
     * マルチロードバランサーのプロトコルリストを設定します。
     *
     * @param elasticLoadBalancerProtocols
     *            マルチロードバランサーのプロトコルリスト
     */
    public void setElasticLoadBalancerProtocols(List<String> elasticLoadBalancerProtocols) {
        this.elasticLoadBalancerProtocols = elasticLoadBalancerProtocols;
    }

    /**
     * マルチロードバランサーのプロトコルの配列を設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerProtocols
     *            マルチロードバランサーのプロトコルの配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withElasticLoadBalancerProtocols(
        String... elasticLoadBalancerProtocols) {
        if (this.elasticLoadBalancerProtocols == null)
            this.elasticLoadBalancerProtocols = new ArrayList<String>();
        for (String elasticLoadBalancerProtocol : elasticLoadBalancerProtocols) {
            getElasticLoadBalancerProtocols().add(elasticLoadBalancerProtocol);
        }
        return this;
    }

    /**
     * マルチロードバランサーのプロトコルリストを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerProtocols
     *            マルチロードバランサーのプロトコルリスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withElasticLoadBalancerProtocols(
        List<String> elasticLoadBalancerProtocols) {
        if (this.elasticLoadBalancerProtocols == null)
            this.elasticLoadBalancerProtocols = new ArrayList<String>();
        if (elasticLoadBalancerProtocols != null) {
            getElasticLoadBalancerProtocols().addAll(elasticLoadBalancerProtocols);
        }
        return this;
    }

    /**
     * マルチロードバランサーの待ち受けポートリストを取得します。
     *
     * @return マルチロードバランサーの待ち受けポートリスト
     */
    @Query(name = "ElasticLoadBalancerPort")
    public List<String> getElasticLoadBalancerPorts() {
        return elasticLoadBalancerPorts;
    }

    /**
     * マルチロードバランサーの待ち受けポートリストを設定します。
     *
     * @param elasticLoadBalancerPorts
     *            マルチロードバランサーの待ち受けポートリスト
     */
    public void setElasticLoadBalancerPorts(List<String> elasticLoadBalancerPorts) {
        this.elasticLoadBalancerPorts = elasticLoadBalancerPorts;
    }

    /**
     * マルチロードバランサーの待ち受けポートリストの配列を設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerPorts
     *            マルチロードバランサーの待ち受けポートの配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withElasticLoadBalancerPorts(
        String... elasticLoadBalancerPorts) {
        if (this.elasticLoadBalancerPorts == null)
            this.elasticLoadBalancerPorts = new ArrayList<String>();
        for (String elasticLoadBalancerPort : elasticLoadBalancerPorts) {
            getElasticLoadBalancerPorts().add(elasticLoadBalancerPort);
        }
        return this;
    }

    /**
     * マルチロードバランサーの待ち受けポートリストを設定し、自オブジェクトを返します。
     *
     * @param elasticLoadBalancerPorts
     *            マルチロードバランサーの待ち受けポートリスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withElasticLoadBalancerPorts(
        List<String> elasticLoadBalancerPorts) {
        if (this.elasticLoadBalancerPorts == null)
            this.elasticLoadBalancerPorts = new ArrayList<String>();
        if (elasticLoadBalancerPorts != null) {
            getElasticLoadBalancerPorts().addAll(elasticLoadBalancerPorts);
        }
        return this;
    }

    /**
     * 監視内容リストを取得します。
     *
     * @return 監視内容リスト
     */
    @Query(name = "Rule")
    public List<RuleUpdate> getRules() {
        return rules;
    }

    /**
     * 監視内容リストを設定します。
     *
     * @param rules
     *            監視内容リスト
     * 
     */
    public void setRules(List<RuleUpdate> rules) {
        this.rules = rules;
    }

    /**
     * 監視内容の配列を設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容リストの配列
     * 
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withRules(
        RuleUpdate... rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleUpdate>();
        for (RuleUpdate rule : rules) {
            getRules().add(rule);
        }
        return this;
    }

    /**
     * 監視内容リストを設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容リスト
     * 
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withRules(
        List<RuleUpdate> rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleUpdate>();
        if (rules != null) {
            getRules().addAll(rules);
        }
        return this;
    }

    /**
     * 監視通知の条件を取得します。
     *
     * @return 監視通知の条件
     */
    @Query(name = "AlarmCondition")
    public String getAlarmCondition() {
        return alarmCondition;
    }

    /**
     * 監視通知の条件を設定します。
     *
     * @param alarmCondition
     *            監視通知の条件
     */
    public void setAlarmCondition(String alarmCondition) {
        this.alarmCondition = alarmCondition;
    }

    /**
     * 監視通知の条件を設定し、自オブジェクトを返します。
     *
     * @param alarmCondition
     *            監視通知の条件
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withAlarmCondition(String alarmCondition) {
        setAlarmCondition(alarmCondition);
        return this;
    }

    /**
     * 通知先メールアドレスリストを取得します。
     *
     * @return 通知先メールアドレスリスト
     */
    @Query(name = "EmailAddress")
    public List<String> getEmailAddresses() {
        return emailAddresses;
    }

    /**
     * 通知先メールアドレスリストを設定します。
     *
     * @param emailAddresses
     *            通知先メールアドレスリスト
     */
    public void setEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    /**
     * 通知先メールアドレスの配列を設定し、自オブジェクトを返します。
     *
     * @param emailAddresses
     *            通知先メールアドレスの配列
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withEmailAddresses(
        String... emailAddresses) {
        if (this.emailAddresses == null)
            this.emailAddresses = new ArrayList<String>();
        for (String emailAddress : emailAddresses) {
            getEmailAddresses().add(emailAddress);
        }
        return this;
    }

    /**
     * 通知先メールアドレスリストを設定し、自オブジェクトを返します。
     *
     * @param emailAddresses
     *            通知先メールアドレスリスト
     * @return 自オブジェクト
     */
    public NiftyUpdateAlarmRequest withEmailAddresses(
        List<String> emailAddresses) {
        if (this.emailAddresses == null)
            this.emailAddresses = new ArrayList<String>();
        if (emailAddresses != null) {
            getEmailAddresses().addAll(emailAddresses);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ruleName=");
        builder.append(ruleName);
        builder.append(", ruleNameUpdate=");
        builder.append(ruleNameUpdate);
        builder.append(", functionName=");
        builder.append(functionName);
        builder.append(", description=");
        builder.append(description);
        builder.append(", instanceIds=");
        builder.append(instanceIds);
        builder.append(", loadBalancerNames=");
        builder.append(loadBalancerNames);
        builder.append(", loadBalancerPorts=");
        builder.append(loadBalancerPorts);
        builder.append(", partitions=");
        builder.append(partitions);
        builder.append(", elasticLoadBalancerNames=");
        builder.append(elasticLoadBalancerNames);
        builder.append(", elasticLoadBalancerProtocols=");
        builder.append(elasticLoadBalancerProtocols);
        builder.append(", elasticLoadBalancerPorts=");
        builder.append(elasticLoadBalancerPorts);
        builder.append(", rules=");
        builder.append(rules);
        builder.append(", alarmCondition=");
        builder.append(alarmCondition);
        builder.append(", emailAddresses=");
        builder.append(emailAddresses);
        builder.append("]");
        return builder.toString();
    }
}
