/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeAlarmsリクエストクラス。<br />
 * このクラスはNiftyDescribeAlarmsへのリクエストを構築します。
 */
@Action("NiftyDescribeAlarms")
public class NiftyDescribeAlarmsRequest implements Request {

    /** 監視内容リスト */
    private List<RuleDescribe> rules;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyDescribeAlarmsRequest() {
    }

    /**
     * 監視内容リストを取得します。
     *
     * @return 監視内容リスト
     */
    @Query(name = "Rule")
    public List<RuleDescribe> getRules() {
        return rules;
    }

    /**
     * 監視内容リストを設定します。
     *
     * @param rules
     *            監視内容リスト
     */
    public void setRules(List<RuleDescribe> rules) {
        this.rules = rules;
    }

    /**
     * 監視内容の配列を設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmsRequest withRules(
        RuleDescribe... rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleDescribe>();
        for (RuleDescribe rule : rules) {
            getRules().add(rule);
        }
        return this;
    }

    /**
     * 監視内容リストを設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容リスト
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmsRequest withRules(
        List<RuleDescribe> rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleDescribe>();
        if (rules != null) {
            getRules().addAll(rules);
        }
        return this;
    }
}
