/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.alarm.model.transform.AlarmTargetSetConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeAlarmsPartitions結果処理クラス。<br />
 * このクラスはNiftyDescribeAlarmsPartitionsのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeAlarmsPartitionsResponse")
public class NiftyDescribeAlarmsPartitionsResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** 取得した情報リスト */
    @XStreamAlias("alarmTargetSet")
    @XStreamConverter(AlarmTargetSetConverter.class)
    private List<AlarmTargetSet> alarmTargets;

    /**
     * リクエスト識別子を取得します。
     * 
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     * 
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     * 
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmsPartitionsResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * 取得した情報リストを取得します。
     *
     * @return 取得した情報リスト
     */
    public List<AlarmTargetSet> getAlarmTargets() {
        return alarmTargets;
    }

    /**
     * 取得した情報リストを設定します。
     *
     * @param alarmTargets
     *            取得した情報リスト
     */
    public void setAlarmTargets(List<AlarmTargetSet> alarmTargets) {
        this.alarmTargets = alarmTargets;
    }

    /**
     * 取得した情報の配列を設定し、自オブジェクトを返します。
     *
     * @param alarmTargets
     *            取得した情報の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmsPartitionsResult withAlarmTargets(AlarmTargetSet... alarmTargets) {
        if (this.alarmTargets == null)
            this.alarmTargets = new ArrayList<AlarmTargetSet>();
        for (AlarmTargetSet alarmTarget : alarmTargets) {
            getAlarmTargets().add(alarmTarget);
        }
        return this;
    }

    /**
     * 取得した情報リストを設定し、自オブジェクトを返します。
     *
     * @param alarmTargets
     *            取得した情報リスト
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmsPartitionsResult
        withAlarmTargets(Collection<AlarmTargetSet> alarmTargets) {
        if (this.alarmTargets == null)
            this.alarmTargets = new ArrayList<AlarmTargetSet>();
        if (alarmTargets != null) {
            getAlarmTargets().addAll(alarmTargets);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(", alarmTargets=");
        builder.append(alarmTargets);
        builder.append("]");
        return builder.toString();
    }
}
