/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Result;
import com.nifty.cloud.sdk.alarm.model.transform.NiftyDescribeAlarmRulesActivitiesResultConverter;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;

/**
 * NiftyDescribeAlarmRulesActivities結果処理クラス。<br />
 * このクラスはNiftyDescribeAlarmRulesActivitiesのレスポンスを格納します。
 */
@XStreamAlias("NiftyDescribeAlarmRulesActivitiesResponse")
@XStreamConverter(NiftyDescribeAlarmRulesActivitiesResultConverter.class)
public class NiftyDescribeAlarmRulesActivitiesResult extends Result {

    /** リクエスト識別子 */
    @XStreamAlias("requestId")
    private String requestId;

    /** 取得した情報セットリスト */
    @XStreamAlias("reservationSet")
    private List<AlarmRulesActivitiesReservationSet> reservationSets;

    /**
     * リクエスト識別子を取得します。
     * 
     * @return リクエスト識別子
     */
    public String getRequestId() {
        return requestId;
    }

    /**
     * リクエスト識別子を設定します。
     * 
     * @param requestId
     *            リクエスト識別子
     */
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    /**
     * リクエスト識別子を設定し、自オブジェクトを返します。
     * 
     * @param requestId
     *            リクエスト識別子
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmRulesActivitiesResult withRequestId(String requestId) {
        setRequestId(requestId);
        return this;
    }

    /**
     * 取得した情報セットリストを取得します。
     * 
     * @return 取得した情報セットリスト
     */
    public List<AlarmRulesActivitiesReservationSet> getReservationSets() {
        return reservationSets;
    }

    /**
     * 取得した情報セットリストを設定します。
     * 
     * @param reservationSets
     *            取得した情報セットリスト
     */
    public void setReservationSets(List<AlarmRulesActivitiesReservationSet> reservationSets) {
        this.reservationSets = reservationSets;
    }

    /**
     * 取得した情報セットの配列を設定し、自オブジェクトを返します。
     *
     * @param reservationSets
     *            取得した情報セットの配列
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmRulesActivitiesResult
        withReservationSets(AlarmRulesActivitiesReservationSet... reservationSets) {
        if (this.reservationSets == null)
            this.reservationSets = new ArrayList<AlarmRulesActivitiesReservationSet>();
        for (AlarmRulesActivitiesReservationSet reservationSet : reservationSets) {
            getReservationSets().add(reservationSet);
        }
        return this;
    }

    /**
     * 取得した情報セットリストを設定し、自オブジェクトを返します。
     *
     * @param reservationSets
     *            取得した情報セットリスト
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmRulesActivitiesResult
        withReservationSets(Collection<AlarmRulesActivitiesReservationSet> reservationSets) {
        if (this.reservationSets == null)
            this.reservationSets = new ArrayList<AlarmRulesActivitiesReservationSet>();
        if (reservationSets != null) {
            getReservationSets().addAll(reservationSets);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[requestId=");
        builder.append(requestId);
        builder.append(", reservationSets=");
        builder.append(reservationSets);
        builder.append("]");
        return builder.toString();
    }

}
