/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDescribeAlarmHistoryリクエストクラス。<br />
 * このクラスはNiftyDescribeAlarmHistoryへのリクエストを構築します。
 */
@Action("NiftyDescribeAlarmHistory")
public class NiftyDescribeAlarmHistoryRequest implements Request {

    /** 監視内容リスト */
    private List<RuleHistory> rules;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyDescribeAlarmHistoryRequest() {
    }

    /**
     * 監視内容リストを指定し、NiftyDescribeAlarmHistoryRequestを構築します。
     *
     * @param rules
     *            監視内容リスト
     */
    public NiftyDescribeAlarmHistoryRequest(List<RuleHistory> rules) {
        this.rules = rules;
    }

    /**
     * 監視内容リストを取得します。
     *
     * @return 監視内容リスト
     */
    @Query(name = "Rule")
    public List<RuleHistory> getRules() {
        return rules;
    }

    /**
     * 監視内容リストを設定します。
     *
     * @param rules
     *            監視内容リスト
     */
    public void setRules(List<RuleHistory> rules) {
        this.rules = rules;
    }

    /**
     * 監視内容の配列を設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容の配列
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmHistoryRequest
        withRules(RuleHistory... rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleHistory>();
        for (RuleHistory rule : rules) {
            getRules().add(rule);
        }
        return this;
    }

    /**
     * 監視内容リストを設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容リスト
     * @return 自オブジェクト
     */
    public NiftyDescribeAlarmHistoryRequest
        withRules(Collection<RuleHistory> rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleHistory>();
        if (rules != null) {
            getRules().addAll(rules);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[rules=");
        builder.append(rules);
        builder.append("]");
        return builder.toString();
    }
}
