/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import com.nifty.cloud.sdk.Request;
import com.nifty.cloud.sdk.annotation.Action;
import com.nifty.cloud.sdk.annotation.Query;

/**
 * NiftyDeleteAlarmリクエストクラス。<br />
 * このクラスはNiftyDeleteAlarmへのリクエストを構築します。
 */
@Action("NiftyDeleteAlarm")
public class NiftyDeleteAlarmRequest implements Request {

    /** 監視ルール名 */
    private String ruleName;

    /** 機能名 */
    private String functionName;

    /**
     * デフォルトコンストラクタ。
     */
    public NiftyDeleteAlarmRequest() {
    }

    /**
     * 監視ルール名, 機能名を指定し、NiftyDeleteAlarmRequestを構築します。
     *
     * @param ruleName
     *            監視ルール名
     * @param functionName
     *            機能名
     */
    public NiftyDeleteAlarmRequest(String ruleName, String functionName) {
        this.ruleName = ruleName;
        this.functionName = functionName;
    }

    /**
     * 監視ルール名を取得します。
     *
     * @return 監視ルール名
     */
    @Query(name = "RuleName", require = true)
    public String getRuleName() {
        return ruleName;
    }

    /**
     * 監視ルール名を設定します。
     *
     * @param ruleName
     *            監視ルール名
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 監視ルール名を設定し、自オブジェクトを返します。
     *
     * @param ruleName
     *            監視ルール名
     * @return 自オブジェクト
     */
    public NiftyDeleteAlarmRequest withRuleName(String ruleName) {
        setRuleName(ruleName);
        return this;
    }

    /**
     * 機能名を取得します。
     *
     * @return 機能名
     */
    @Query(name = "FunctionName", require = true)
    public String getFunctionName() {
        return functionName;
    }

    /**
     * 機能名を設定します。
     *
     * @param functionName
     *            機能名
     */
    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    /**
     * 機能名を設定し、自オブジェクトを返します。
     *
     * @param functionName
     *            機能名
     * @return 自オブジェクト
     */
    public NiftyDeleteAlarmRequest withFunctionName(String functionName) {
        setFunctionName(functionName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ruleName=");
        builder.append(ruleName);
        builder.append(", functionName=");
        builder.append(functionName);
        builder.append("]");
        return builder.toString();
    }
}
