/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

/**
 * 通知先メールアドレスクラス。<br />
 * このクラスは通知先メールアドレスを格納します。
 */
public class EmailAddressSet {

    /** 通知先メールアドレス */
    private String emailAddress;

    /**
     * 通知先メールアドレスを取得します。
     *
     * @return 通知先メールアドレス
     */
    public String getEmailAddress() {
        return emailAddress;
    }

    /**
     * 通知先メールアドレスを設定します。
     *
     * @param emailAddress
     *            通知先メールアドレス
     */
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    /**
     * 通知先メールアドレスを設定し、自オブジェクトを返します。
     *
     * @param emailAddress
     *            通知先メールアドレス
     * @return 自オブジェクト
     */
    public EmailAddressSet withEmailAddress(String emailAddress) {
        setEmailAddress(emailAddress);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[emailAddress=");
        builder.append(emailAddress);
        builder.append("]");
        return builder.toString();
    }
}
