/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

/**
 * 監視対象セットクラス。<br />
 * このクラスは監視対象セット情報を格納します。
 */
public class AlarmTargetsSet {

    /** 対象リソース名 */
    private String resourceName;

    /**
     * 対象リソース名を取得します。
     *
     * @return 対象リソース名
     */
    public String getResourceName() {
        return resourceName;
    }

    /**
     * 対象リソース名を設定します。
     *
     * @param resourceName
     *            対象リソース名
     */
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * 対象リソース名を設定し、自オブジェクトを返します。
     *
     * @param resourceName
     *            対象リソース名
     * @return 自オブジェクト
     */
    public AlarmTargetsSet withResourceName(String resourceName) {
        setResourceName(resourceName);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[resourceName=");
        builder.append(resourceName);
        builder.append("]");
        return builder.toString();
    }
}
