/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * AlarmTargetSet情報クラス。<br />
 * このクラスはAlarmTargetSet情報を格納します。
 */
public class AlarmTargetSet {

    /** サーバー名 */
    private String instanceId;

    /** パーティション情報リスト */
    private List<PartitionsSet> partitions;

    /**
     * サーバー名を取得します。
     * 
     * @return サーバー名
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * サーバー名を設定します。
     * 
     * @param instanceId
     *            サーバー名
     */
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    /**
     * サーバー名を設定し、自オブジェクトを返します。
     * 
     * @param instanceId
     *            サーバー名
     * @return 自オブジェクト
     */
    public AlarmTargetSet withInstanceId(String instanceId) {
        setInstanceId(instanceId);
        return this;
    }

    /**
     * パーティション情報リストを取得します。
     *
     * @return パーティション情報リスト
     */
    public List<PartitionsSet> getPartitions() {
        return partitions;
    }

    /**
     * パーティション情報リストを設定します。
     *
     * @param partitions
     *            パーティション情報リスト
     */
    public void setPartitions(List<PartitionsSet> partitions) {
        this.partitions = partitions;
    }

    /**
     * パーティション情報の配列を設定し、自オブジェクトを返します。
     *
     * @param partitions
     *            パーティション情報の配列
     * @return 自オブジェクト
     */
    public AlarmTargetSet withPartitions(PartitionsSet... partitions) {
        if (this.partitions == null)
            this.partitions = new ArrayList<PartitionsSet>();
        for (PartitionsSet partition : partitions) {
            getPartitions().add(partition);
        }
        return this;
    }

    /**
     * パーティション情報リストを設定し、自オブジェクトを返します。
     *
     * @param partitions
     *            パーティション情報リスト
     * @return 自オブジェクト
     */
    public AlarmTargetSet withPartitions(Collection<PartitionsSet> partitions) {
        if (this.partitions == null)
            this.partitions = new ArrayList<PartitionsSet>();
        if (partitions != null) {
            getPartitions().addAll(partitions);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[instanceId=");
        builder.append(instanceId);
        builder.append(", partitions=");
        builder.append(partitions);
        builder.append("]");
        return builder.toString();
    }
}
