/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * AlarmRulesActivitiesSet情報クラス。<br />
 * このクラスはAlarmRulesActivitiesSet情報を格納します。
 */
public class AlarmRulesActivitiesSet {

    /** 監視項目 */
    private String dataType;

    /** 監視ルールログ日時セットリスト */
    private List<AlarmRulesActivitiesDateSet> alarmRulesActivitiesDateSets;

    /**
     * 監視項目を取得します。
     *
     * @return 監視項目
     */
    public String getDataType() {
        return dataType;
    }

    /**
     * 監視項目を設定します。
     *
     * @param dataType
     *            監視項目
     */
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    /**
     * 監視項目を設定し、自オブジェクトを返します。
     *
     * @param dataType
     *            監視項目
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesSet withDataType(String dataType) {
        setDataType(dataType);
        return this;
    }

    /**
     * 監視ルールログ日時セットリストを取得します。
     * 
     * @return 監視ルールログ日時セットリスト
     */
    public List<AlarmRulesActivitiesDateSet> getAlarmRulesActivitiesDateSets() {
        return alarmRulesActivitiesDateSets;
    }

    /**
     * 監視ルールログ日時セットリストを設定します。
     * 
     * @param alarmRulesActivitiesDateSets
     *            監視ルールログ日時セットリスト
     */
    public void setAlarmRulesActivitiesDateSets(
        List<AlarmRulesActivitiesDateSet> alarmRulesActivitiesDateSets) {
        this.alarmRulesActivitiesDateSets = alarmRulesActivitiesDateSets;
    }

    /**
     * 監視ルールログ日時セットの配列を設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesDateSets
     *            監視ルールログ日時セットの配列
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesSet
        withAlarmRulesActivitiesDateSets(
            AlarmRulesActivitiesDateSet... alarmRulesActivitiesDateSets) {
        if (this.alarmRulesActivitiesDateSets == null)
            this.alarmRulesActivitiesDateSets = new ArrayList<AlarmRulesActivitiesDateSet>();
        for (AlarmRulesActivitiesDateSet alarmRulesActivitiesDateSet : alarmRulesActivitiesDateSets) {
            getAlarmRulesActivitiesDateSets().add(alarmRulesActivitiesDateSet);
        }
        return this;
    }

    /**
     * 監視ルールログ日時セットリストを設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesDateSets
     *            監視ルールログ日時セットリスト
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesSet
        withAlarmRulesActivitiesDateSets(
            Collection<AlarmRulesActivitiesDateSet> alarmRulesActivitiesDateSets) {
        if (this.alarmRulesActivitiesDateSets == null)
            this.alarmRulesActivitiesDateSets = new ArrayList<AlarmRulesActivitiesDateSet>();
        if (alarmRulesActivitiesDateSets != null) {
            getAlarmRulesActivitiesDateSets().addAll(alarmRulesActivitiesDateSets);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[dataType=");
        builder.append(dataType);
        builder.append(", alarmRulesActivitiesDateSets=");
        builder.append(alarmRulesActivitiesDateSets);
        builder.append("]");
        return builder.toString();
    }
}
