/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * AlarmRulesActivitiesReservationSet情報クラス。<br />
 * このクラスはAlarmRulesActivitiesReservationSet情報を格納します。
 */
public class AlarmRulesActivitiesReservationSet {

    /** 監視ルール名 */
    private String ruleName;

    /** 機能名 */
    private String functionName;

    /** 監視ルールログ情報セットリスト */
    private List<AlarmRulesActivitiesSet> alarmRulesActivitiesSets;

    /**
     * 監視ルール名を取得します。
     * 
     * @return 監視ルール名
     */
    public String getRuleName() {
        return ruleName;
    }

    /**
     * 監視ルール名を設定します。
     * 
     * @param ruleName
     *            監視ルール名
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 監視ルール名を設定し、自オブジェクトを返します。
     * 
     * @param ruleName
     *            監視ルール名
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesReservationSet withRuleName(String ruleName) {
        setRuleName(ruleName);
        return this;
    }

    /**
     * 機能名を取得します。
     * 
     * @return 機能名
     */
    public String getFunctionName() {
        return functionName;
    }

    /**
     * 機能名を設定します。
     * 
     * @param functionName
     *            機能名
     */
    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    /**
     * 機能名を設定し、自オブジェクトを返します。
     * 
     * @param functionName
     *            機能名
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesReservationSet withFunctionName(String functionName) {
        setFunctionName(functionName);
        return this;
    }

    /**
     * 監視ルールログ情報セットリストを取得します。
     * 
     * @return 監視ルールログ情報セットリスト
     */
    public List<AlarmRulesActivitiesSet> getAlarmRulesActivitiesSets() {
        return alarmRulesActivitiesSets;
    }

    /**
     * 監視ルールログ情報セットリストを設定します。
     * 
     * @param alarmRulesActivitiesSets
     *            監視ルールログ情報セットリスト
     */
    public void
        setAlarmRulesActivitiesSets(List<AlarmRulesActivitiesSet> alarmRulesActivitiesSets) {
        this.alarmRulesActivitiesSets = alarmRulesActivitiesSets;
    }

    /**
     * 監視ルールログ情報セットの配列を設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesSets
     *            監視ルールログ情報セットの配列
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesReservationSet
        withAlarmRulesActivitiesSets(AlarmRulesActivitiesSet... alarmRulesActivitiesSets) {
        if (this.alarmRulesActivitiesSets == null)
            this.alarmRulesActivitiesSets = new ArrayList<AlarmRulesActivitiesSet>();
        for (AlarmRulesActivitiesSet alarmRulesActivitiesSet : alarmRulesActivitiesSets) {
            getAlarmRulesActivitiesSets().add(alarmRulesActivitiesSet);
        }
        return this;
    }

    /**
     * 監視ルールログ情報セットリストを設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesSets
     *            監視ルールログ情報セットリスト
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesReservationSet
        withAlarmRulesActivitiesSets(Collection<AlarmRulesActivitiesSet> alarmRulesActivitiesSets) {
        if (this.alarmRulesActivitiesSets == null)
            this.alarmRulesActivitiesSets = new ArrayList<AlarmRulesActivitiesSet>();
        if (alarmRulesActivitiesSets != null) {
            getAlarmRulesActivitiesSets().addAll(alarmRulesActivitiesSets);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ruleName=");
        builder.append(ruleName);
        builder.append(", functionName=");
        builder.append(functionName);
        builder.append(", alarmRulesActivitiesSets=");
        builder.append(alarmRulesActivitiesSets);
        builder.append("]");
        return builder.toString();
    }
}
