/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.Date;

/**
 * AlarmRulesActivitiesEventSet情報クラス。<br />
 * このクラスはAlarmRulesActivitiesEventSet情報を格納します。
 */
public class AlarmRulesActivitiesEventSet{

    /** 監視ルールログのイベント発生日時 */
    private Date alarmRulesActivitiesEventDatetime;

    /** 監視ルールログのイベント */
    private String alarmRulesActivitiesEvent;

    /** リソース名 */
    private String resourceName;

    /** リソース値 */
    private String value;

    /**
     * 監視ルールログのイベント発生日時を取得します。
     *
     * @return 監視ルールログのイベント発生日時
     */
    public Date getAlarmRulesActivitiesEventDatetime() {
        return alarmRulesActivitiesEventDatetime;
    }

    /**
     * 監視ルールログのイベント発生日時を設定します。
     *
     * @param alarmRulesActivitiesEventDatetime
     *            監視ルールログのイベント発生日時
     */
    public void setAlarmRulesActivitiesEventDatetime(Date alarmRulesActivitiesEventDatetime) {
        this.alarmRulesActivitiesEventDatetime = alarmRulesActivitiesEventDatetime;
    }

    /**
     * 監視ルールログのイベント発生日時を設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesEventDatetime
     *            監視ルールログのイベント発生日時
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesEventSet
        withAlarmRulesActivitiesEventDatetime(Date alarmRulesActivitiesEventDatetime) {
        setAlarmRulesActivitiesEventDatetime(alarmRulesActivitiesEventDatetime);
        return this;
    }

    /**
     * 監視ルールログのイベントを取得します。
     *
     * @return 監視ルールログのイベント
     */
    public String getAlarmRulesActivitiesEvent() {
        return alarmRulesActivitiesEvent;
    }

    /**
     * 監視ルールログのイベントを設定します。
     *
     * @param alarmRulesActivitiesEvent
     *            監視ルールログのイベント
     */
    public void setAlarmRulesActivitiesEvent(String alarmRulesActivitiesEvent) {
        this.alarmRulesActivitiesEvent = alarmRulesActivitiesEvent;
    }

    /**
     * 監視ルールログのイベントを設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesEvent
     *            監視ルールログのイベント
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesEventSet
        withAlarmRulesActivitiesEvent(String alarmRulesActivitiesEvent) {
        setAlarmRulesActivitiesEvent(alarmRulesActivitiesEvent);
        return this;
    }

    /**
     * リソース名を取得します。
     *
     * @return リソース名
     */
    public String getResourceName() {
        return resourceName;
    }

    /**
     * リソース名を設定します。
     *
     * @param resourceName
     *            リソース名
     */
    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * リソース名を設定し、自オブジェクトを返します。
     *
     * @param resourceName
     *            リソース名
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesEventSet withResourceName(String resourceName) {
        setResourceName(resourceName);
        return this;
    }

    /**
     * リソース値を取得します。
     *
     * @return リソース値
     */
    public String getValue() {
        return value;
    }

    /**
     * リソース値を設定します。
     *
     * @param value
     *            リソース値
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * リソース値を設定し、自オブジェクトを返します。
     *
     * @param value
     *            リソース値
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesEventSet withValue(String value) {
        setValue(value);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[alarmRulesActivitiesEventDatetime=");
        builder.append(alarmRulesActivitiesEventDatetime);
        builder.append(", alarmRulesActivitiesEvent=");
        builder.append(alarmRulesActivitiesEvent);
        builder.append(", resourceName=");
        builder.append(resourceName);
        builder.append(", value=");
        builder.append(value);
        builder.append("]");
        return builder.toString();
    }
}
