/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * AlarmRulesActivitiesDateSet情報クラス。<br />
 * このクラスはAlarmRulesActivitiesDateSet情報を格納します。
 */
public class AlarmRulesActivitiesDateSet {

    /** 監視ルールログ日付 */
    private String date;

    /** 監視ルールログのイベント情報セットリスト */
    private List<AlarmRulesActivitiesEventSet> alarmRulesActivitiesEvents;

    /**
     * 監視ルールログ日付を取得します。
     *
     * @return 監視ルールログ日付
     */
    public String getDate() {
        return date;
    }

    /**
     * 監視ルールログ日付を設定します。
     *
     * @param date
     *            監視ルールログ日付
     */
    public void setDate(String date) {
        this.date = date;
    }

    /**
     * 監視ルールログ日付を設定し、自オブジェクトを返します。
     *
     * @param date
     *            監視ルールログ日付
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesDateSet withDate(String date) {
        setDate(date);
        return this;
    }

    /**
     * 監視ルールログのイベント情報セットリストを取得します。
     * 
     * @return 監視ルールログのイベント情報セットリスト
     */
    public List<AlarmRulesActivitiesEventSet> getAlarmRulesActivitiesEvents() {
        return alarmRulesActivitiesEvents;
    }

    /**
     * 監視ルールログのイベント情報セットリストを設定します。
     * 
     * @param alarmRulesActivitiesEvents
     *            監視ルールログのイベント情報セットリスト
     */
    public void setAlarmRulesActivitiesEvents(
        List<AlarmRulesActivitiesEventSet> alarmRulesActivitiesEvents) {
        this.alarmRulesActivitiesEvents = alarmRulesActivitiesEvents;
    }

    /**
     * 監視ルールログのイベント情報セットの配列を設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesEvents
     *            監視ルールログのイベント情報セットの配列
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesDateSet
        withAlarmRulesActivitiesEvents(AlarmRulesActivitiesEventSet... alarmRulesActivitiesEvents) {
        if (this.alarmRulesActivitiesEvents == null)
            this.alarmRulesActivitiesEvents =
                new ArrayList<AlarmRulesActivitiesEventSet>();
        for (AlarmRulesActivitiesEventSet alarmRulesActivitiesEvent : alarmRulesActivitiesEvents) {
            getAlarmRulesActivitiesEvents().add(alarmRulesActivitiesEvent);
        }
        return this;
    }

    /**
     * 監視ルールログのイベント情報セットリストを設定し、自オブジェクトを返します。
     *
     * @param alarmRulesActivitiesEventSets
     *            監視ルールログのイベント情報セットリスト
     * @return 自オブジェクト
     */
    public AlarmRulesActivitiesDateSet withAlarmRulesActivitiesEvents(
        Collection<AlarmRulesActivitiesEventSet> alarmRulesActivitiesEvents) {
        if (this.alarmRulesActivitiesEvents == null)
            this.alarmRulesActivitiesEvents = new ArrayList<AlarmRulesActivitiesEventSet>();
        if (alarmRulesActivitiesEvents != null) {
            getAlarmRulesActivitiesEvents().addAll(alarmRulesActivitiesEvents);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[date=");
        builder.append(date);
        builder.append(", alarmRulesActivitiesEvents=");
        builder.append(alarmRulesActivitiesEvents);
        builder.append("]");
        return builder.toString();
    }
}
