/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * 取得した情報セットクラス。<br />
 * このクラスは取得した情報セットを格納します。
 */
public class AlarmReservationSetDescribe {

    /** 監視ルール名 */
    private String ruleName;

    /** メモ */
    private String description;

    /** 監視状態 */
    private String alarmState;

    /** 機能名 */
    private String functionName;

    /** ゾーン名 */
    private String zone;

    /** 監視内容リスト */
    private List<RuleSet> rules;

    /** 監視通知の条件 */
    private String alarmCondition;

    /** 通知先メールアドレスリスト */
    private List<EmailAddressSet> emailAddresses;

    /** 監視対象リスト */
    private List<AlarmTargetsSet> alarmTargets;

    /** 監視ルール作成日時 */
    private Date createdTime;

    /**
     * 監視ルール名を取得します。
     *
     * @return 監視ルール名
     */
    public String getRuleName() {
        return ruleName;
    }

    /**
     * 監視ルール名を設定します。
     *
     * @param ruleName
     *            監視ルール名
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 監視ルール名を設定し、自オブジェクトを返します。
     *
     * @param ruleName
     *            監視ルール名
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withRuleName(String ruleName) {
        setRuleName(ruleName);
        return this;
    }

    /**
     * メモ情報を取得します。
     *
     * @return メモ情報
     */
    public String getDescription() {
        return description;
    }

    /**
     * メモ情報を設定します。
     *
     * @param description
     *            メモ情報
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * メモ情報を設定し、自オブジェクトを返します。
     *
     * @param description
     *            メモ情報
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * 監視状態を取得します。
     *
     * @return 監視状態
     */
    public String getAlarmState() {
        return alarmState;
    }

    /**
     * 監視状態を設定します。
     *
     * @param alarmState
     *            監視状態
     */
    public void setAlarmState(String alarmState) {
        this.alarmState = alarmState;
    }

    /**
     * 監視状態を設定し、自オブジェクトを返します。
     *
     * @param alarmState
     *            監視状態
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withAlarmState(String alarmState) {
        setAlarmState(alarmState);
        return this;
    }

    /**
     * 機能名を取得します。
     *
     * @return 機能名
     */
    public String getFunctionName() {
        return functionName;
    }

    /**
     * 機能名を設定します。
     *
     * @param functionName
     *            機能名
     */
    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    /**
     * 機能名を設定し、自オブジェクトを返します。
     *
     * @param functionName
     *            機能名
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withFunctionName(String functionName) {
        setFunctionName(functionName);
        return this;
    }

    /**
     * ゾーン名を取得します。
     * 
     * @return ゾーン名
     */
    public String getZone() {
        return zone;
    }

    /**
     * ゾーン名を設定します。
     * 
     * @param zone
     *            ゾーン名
     */
    public void setZone(String zone) {
        this.zone = zone;
    }

    /**
     * ゾーン名を設定し、自オブジェクトを返します。
     *
     * @param zone
     *            ゾーン名
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withZone(String zone) {
        setZone(zone);
        return this;
    }

    /**
     * 監視内容リストを取得します。
     * 
     * @return 監視内容リスト
     */
    public List<RuleSet> getRules() {
        return rules;
    }

    /**
     * 監視内容リストを設定します。
     * 
     * @param rules
     *            監視内容リスト
     */
    public void setRules(List<RuleSet> rules) {
        this.rules = rules;
    }

    /**
     * 監視内容の配列を設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容の配列
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withRules(RuleSet... rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleSet>();
        for (RuleSet rule : rules) {
            getRules().add(rule);
        }
        return this;
    }

    /**
     * 監視内容リストを設定し、自オブジェクトを返します。
     *
     * @param rules
     *            監視内容リスト
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withRules(Collection<RuleSet> rules) {
        if (this.rules == null)
            this.rules = new ArrayList<RuleSet>();
        if (rules != null) {
            getRules().addAll(rules);
        }
        return this;
    }

    /**
     * 監視通知の条件を取得します。
     * 
     * @return 監視通知の条件
     */
    public String getAlarmCondition() {
        return alarmCondition;
    }

    /**
     * 監視通知の条件を設定します。
     * 
     * @param alarmCondition
     *            監視通知の条件
     */
    public void setAlarmCondition(String alarmCondition) {
        this.alarmCondition = alarmCondition;
    }

    /**
     * 監視通知の条件を設定し、自オブジェクトを返します。
     *
     * @param alarmCondition
     *            監視通知の条件
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withAlarmCondition(String alarmCondition) {
        setAlarmCondition(alarmCondition);
        return this;
    }

    /**
     * 通知先メールアドレスリストを取得します。
     * 
     * @return 通知先メールアドレスリスト
     */
    public List<EmailAddressSet> getEmailAddresses() {
        return emailAddresses;
    }

    /**
     * 通知先メールアドレスリストを設定します。
     * 
     * @param emailAddresses
     *            通知先メールアドレスリスト
     */
    public void setEmailAddresses(List<EmailAddressSet> emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    /**
     * 通知先メールアドレスの配列を設定し、自オブジェクトを返します。
     *
     * @param emailAddresses
     *            通知先メールアドレスの配列
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withEmailAddresses(EmailAddressSet... emailAddresses) {
        if (this.emailAddresses == null)
            this.emailAddresses = new ArrayList<EmailAddressSet>();
        for (EmailAddressSet emailAddress : emailAddresses) {
            getEmailAddresses().add(emailAddress);
        }
        return this;
    }

    /**
     * 通知先メールアドレスリストを設定し、自オブジェクトを返します。
     *
     * @param emailAddresses
     *            通知先メールアドレスリスト
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe
        withEmailAddresses(Collection<EmailAddressSet> emailAddresses) {
        if (this.emailAddresses == null)
            this.emailAddresses = new ArrayList<EmailAddressSet>();
        if (emailAddresses != null) {
            getEmailAddresses().addAll(emailAddresses);
        }
        return this;
    }

    /**
     * 監視対象リストを取得します。
     * 
     * @return 監視対象リスト
     */
    public List<AlarmTargetsSet> getAlarmTargets() {
        return alarmTargets;
    }

    /**
     * 監視対象リストを設定します。
     * 
     * @param alarmTargets
     *            監視対象リスト
     */
    public void setAlarmTargets(List<AlarmTargetsSet> alarmTargets) {
        this.alarmTargets = alarmTargets;
    }

    /**
     * 監視対象の配列を設定し、自オブジェクトを返します。
     *
     * @param alarmTargets
     *            監視対象の配列
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withAlarmTargets(AlarmTargetsSet... alarmTargets) {
        if (this.alarmTargets == null)
            this.alarmTargets = new ArrayList<AlarmTargetsSet>();
        for (AlarmTargetsSet alarmTarget : alarmTargets) {
            getAlarmTargets().add(alarmTarget);
        }
        return this;
    }

    /**
     * 監視対象リストを設定し、自オブジェクトを返します。
     *
     * @param alarmTargets
     *            監視対象リスト
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withAlarmTargets(Collection<AlarmTargetsSet> alarmTargets) {
        if (this.alarmTargets == null)
            this.alarmTargets = new ArrayList<AlarmTargetsSet>();
        if (alarmTargets != null) {
            getAlarmTargets().addAll(alarmTargets);
        }
        return this;
    }

    /**
     * 監視ルール作成日時を取得します。
     * 
     * @return 監視ルール作成日時
     */
    public Date getCreatedTime() {
        return createdTime;
    }

    /**
     * 監視ルール作成日時を設定します。
     * 
     * @param createdTime
     *            監視ルール作成日時
     */
    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    /**
     * 監視ルール作成日時を設定し、自オブジェクトを返します。
     *
     * @param createdTime
     *            監視ルール作成日時
     * @return 自オブジェクト
     */
    public AlarmReservationSetDescribe withCreatedTime(Date createdTime) {
        setCreatedTime(createdTime);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ruleName=");
        builder.append(ruleName);
        builder.append(", description=");
        builder.append(description);
        builder.append(", alarmState=");
        builder.append(alarmState);
        builder.append(", zone=");
        builder.append(zone);
        builder.append(", rules=");
        builder.append(rules);
        builder.append(", alarmCondition=");
        builder.append(alarmCondition);
        builder.append(", emailAddresses=");
        builder.append(emailAddresses);
        builder.append(", alarmTargets=");
        builder.append(alarmTargets);
        builder.append(", createdTime=");
        builder.append(createdTime);
        builder.append("]");
        return builder.toString();
    }

}
