/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * AlarmReservationSet情報クラス。<br />
 * このクラスはAlarmReservationSet情報を格納します。
 */
public class AlarmReservationSet {

    /** 監視ルール名 */
    private String ruleName;

    /** 機能名 */
    private String functionName;

    /** アラーム日時セットリスト */
    private List<AlarmDateHistorySet> alarmDateHistorys;

    /**
     * 監視ルール名を取得します。
     *
     * @return 監視ルール名
     */
    public String getRuleName() {
        return ruleName;
    }

    /**
     * 監視ルール名を設定します。
     *
     * @param ruleName
     *            監視ルール名
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    /**
     * 監視ルール名を設定し、自オブジェクトを返します。
     *
     * @param ruleName
     *            監視ルール名
     * @return 自オブジェクト
     */
    public AlarmReservationSet withRuleName(String ruleName) {
        setRuleName(ruleName);
        return this;
    }

    /**
     * 機能名を取得します。
     *
     * @return 機能名
     */
    public String getFunctionName() {
        return functionName;
    }

    /**
     * 機能名を設定します。
     *
     * @param functionName
     *            機能名
     */
    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    /**
     * 機能名を設定し、自オブジェクトを返します。
     *
     * @param functionName
     *            機能名
     * @return 自オブジェクト
     */
    public AlarmReservationSet withFunctionName(String functionName) {
        setFunctionName(functionName);
        return this;
    }

    /**
     * アラーム日時セットリストを取得します。
     *
     * @return アラーム日時セットリスト
     */
    public List<AlarmDateHistorySet> getAlarmDateHistorys() {
        return alarmDateHistorys;
    }

    /**
     * アラーム日時セットリストを設定します。
     *
     * @param alarmDateHistorys
     *            アラーム日時セットリスト
     */
    public void setAlarmDateHistorys(List<AlarmDateHistorySet> alarmDateHistorys) {
        this.alarmDateHistorys = alarmDateHistorys;
    }

    /**
     * アラーム日時セットの配列を設定し、自オブジェクトを返します。
     *
     * @param alarmDateHistorys
     *            アラーム日時セットの配列
     * @return 自オブジェクト
     */
    public AlarmReservationSet withAlarmDateHistorys(AlarmDateHistorySet... alarmDateHistorys) {
        if (this.alarmDateHistorys == null)
            this.alarmDateHistorys = new ArrayList<AlarmDateHistorySet>();
        for (AlarmDateHistorySet alarmDateHistory : alarmDateHistorys) {
            getAlarmDateHistorys().add(alarmDateHistory);
        }
        return this;
    }

    /**
     * アラーム日時セットリストを設定し、自オブジェクトを返します。
     *
     * @param alarmDateHistorys
     *            アラーム日時セットリスト
     * @return 自オブジェクト
     */
    public AlarmReservationSet
        withAlarmDateHistorys(Collection<AlarmDateHistorySet> alarmDateHistorys) {
        if (this.alarmDateHistorys == null)
            this.alarmDateHistorys = new ArrayList<AlarmDateHistorySet>();
        if (alarmDateHistorys != null) {
            getAlarmDateHistorys().addAll(alarmDateHistorys);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[ruleName=");
        builder.append(ruleName);
        builder.append(", functionName=");
        builder.append(functionName);
        builder.append(", alarmDateHistorys=");
        builder.append(alarmDateHistorys);
        builder.append("]");
        return builder.toString();
    }
}
