/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.Date;

/**
 * AlarmEventHistorySet情報クラス。<br />
 * このクラスはAlarmEventHistorySet情報を格納します。
 */
public class AlarmEventHistorySet {

    /** アラームイベント発生日時 */
    private Date alarmEventDatetime;

    /** アラームイベント */
    private String alarmEvent;

    /**
     * アラームイベント発生日時を取得します。
     *
     * @return アラームイベント発生日時
     */
    public Date getAlarmEventDatetime() {
        return alarmEventDatetime;
    }

    /**
     * アラームイベント発生日時を設定します。
     *
     * @param alarmEventDatetime
     *            アラームイベント発生日時
     */
    public void setAlarmEventDatetime(Date alarmEventDatetime) {
        this.alarmEventDatetime = alarmEventDatetime;
    }

    /**
     * アラームイベント発生日時を設定し、自オブジェクトを返します。
     *
     * @param alarmEventDatetime
     *            アラームイベント発生日時
     * @return 自オブジェクト
     */
    public AlarmEventHistorySet
        withAlarmRulesActivitiesEventDatetime(Date alarmEventDatetime) {
        setAlarmEventDatetime(alarmEventDatetime);
        return this;
    }

    /**
     * アラームイベントを取得します。
     *
     * @return アラームイベント
     */
    public String getAlarmEvent() {
        return alarmEvent;
    }

    /**
     * アラームイベントを設定します。
     *
     * @param alarmEvent
     *            アラームイベント
     */
    public void setAlarmEvent(String alarmEvent) {
        this.alarmEvent = alarmEvent;
    }

    /**
     * アラームイベントを設定し、自オブジェクトを返します。
     *
     * @param alarmEvent
     *            アラームイベント
     * @return 自オブジェクト
     */
    public AlarmEventHistorySet withAlarmEvent(String alarmEvent) {
        setAlarmEvent(alarmEvent);
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[dalarmEventDatetime=");
        builder.append(alarmEventDatetime);
        builder.append(", alarmEvent=");
        builder.append(alarmEvent);
        builder.append("]");
        return builder.toString();
    }
}
