/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * AlarmDateHistorySet情報クラス。<br />
 * このクラスはAlarmDateHistorySet情報を格納します。
 */
public class AlarmDateHistorySet {

    /** アラーム日付 */
    private String date;

    /** アラームイベント情報セットリスト */
    private List<AlarmEventHistorySet> alarmEventHistorys;

    /**
     * アラーム日付を取得します。
     *
     * @return アラーム日付
     */
    public String getDate() {
        return date;
    }

    /**
     * アラーム日付を設定します。
     *
     * @param date
     *            アラーム日付
     */
    public void setDate(String date) {
        this.date = date;
    }

    /**
     * アラーム日付を設定し、自オブジェクトを返します。
     *
     * @param date
     *            アラーム日付
     * @return 自オブジェクト
     */
    public AlarmDateHistorySet withDate(String date) {
        setDate(date);
        return this;
    }

    /**
     * アラームイベント情報セットリストを取得します。
     * 
     * @return アラームイベント情報セットリスト
     */
    public List<AlarmEventHistorySet> getAlarmEventHistorys() {
        return alarmEventHistorys;
    }

    /**
     * アラームイベント情報セットリストを設定します。
     * 
     * @param alarmEventHistorys
     *            アラームイベント情報セットリスト
     */
    public void setAlarmEventHistorys(
        List<AlarmEventHistorySet> alarmEventHistorys) {
        this.alarmEventHistorys = alarmEventHistorys;
    }

    /**
     * アラームイベント情報セットの配列を設定し、自オブジェクトを返します。
     *
     * @param alarmEventHistorys
     *            アラームイベント情報セットの配列
     * @return 自オブジェクト
     */
    public AlarmDateHistorySet
        withAlarmEventHistorys(AlarmEventHistorySet... alarmEventHistorys) {
        if (this.alarmEventHistorys == null)
            this.alarmEventHistorys =
                new ArrayList<AlarmEventHistorySet>();
        for (AlarmEventHistorySet alarmEventHistory : alarmEventHistorys) {
            getAlarmEventHistorys().add(alarmEventHistory);
        }
        return this;
    }

    /**
     * アラームイベント情報セットリストを設定し、自オブジェクトを返します。
     *
     * @param alarmEventHistorys
     *            アラームイベント情報セットリスト
     * @return 自オブジェクト
     */
    public AlarmDateHistorySet withAlarmEventHistorys(
        Collection<AlarmEventHistorySet> alarmEventHistorys) {
        if (this.alarmEventHistorys == null)
            this.alarmEventHistorys = new ArrayList<AlarmEventHistorySet>();
        if (alarmEventHistorys != null) {
            getAlarmEventHistorys().addAll(alarmEventHistorys);
        }
        return this;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[date=");
        builder.append(date);
        builder.append(", alarmEventHistorys=");
        builder.append(alarmEventHistorys);
        builder.append("]");
        return builder.toString();
    }
}
