/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm;

import com.nifty.cloud.sdk.BaseClient;
import com.nifty.cloud.sdk.ClientConfiguration;
import com.nifty.cloud.sdk.alarm.model.NiftyCreateAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyCreateAlarmResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDeleteAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDeleteAlarmResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmHistoryRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmHistoryResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsPartitionsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsPartitionsResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsResult;
import com.nifty.cloud.sdk.alarm.model.NiftyUpdateAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyUpdateAlarmResult;
import com.nifty.cloud.sdk.auth.Credentials;

/**
 * NIFCLOUD API クライアント 具象クラス。 基本監視カテゴリ クライアント。<br />
 * 基本監視カテゴリの同期クライアントの具象クラスです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public class NiftyAlarmClient extends BaseClient implements NiftyAlarm {

    /**
     * 認証情報を指定し、基本監視テゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     */
    public NiftyAlarmClient(Credentials credential) {
        super(credential, new ClientConfiguration());
    }

    /**
     * 認証情報、クライアント設定を指定し、基本監視カテゴリクライアントを構築します。
     *
     * @param credential
     *            認証情報
     * @param configuration
     *            クライアント設定
     */
    public NiftyAlarmClient(Credentials credential, ClientConfiguration configuration) {
        super(credential, configuration);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyCreateAlarmResult niftyCreateAlarm(NiftyCreateAlarmRequest request) {
        return (NiftyCreateAlarmResult) client.execute(request, NiftyCreateAlarmResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeAlarmsResult niftyDescribeAlarms(NiftyDescribeAlarmsRequest request) {
        return (NiftyDescribeAlarmsResult) client.execute(request, NiftyDescribeAlarmsResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyUpdateAlarmResult niftyUpdateAlarm(NiftyUpdateAlarmRequest request) {
        return (NiftyUpdateAlarmResult) client.execute(request, NiftyUpdateAlarmResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDeleteAlarmResult niftyDeleteAlarm(NiftyDeleteAlarmRequest request) {
        return (NiftyDeleteAlarmResult) client.execute(request, NiftyDeleteAlarmResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeAlarmsPartitionsResult
        niftyDescribeAlarmsPartitions(NiftyDescribeAlarmsPartitionsRequest request) {
        return (NiftyDescribeAlarmsPartitionsResult) client.execute(request,
            NiftyDescribeAlarmsPartitionsResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeAlarmHistoryResult
        niftyDescribeAlarmHistory(NiftyDescribeAlarmHistoryRequest request) {
        return (NiftyDescribeAlarmHistoryResult) client.execute(request,
            NiftyDescribeAlarmHistoryResult.class);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NiftyDescribeAlarmRulesActivitiesResult
        niftyDescribeAlarmRulesActivities(NiftyDescribeAlarmRulesActivitiesRequest request) {
        return (NiftyDescribeAlarmRulesActivitiesResult) client.execute(request,
            NiftyDescribeAlarmRulesActivitiesResult.class);
    }

}
