/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm;

import java.util.concurrent.Future;

import com.nifty.cloud.sdk.alarm.model.NiftyCreateAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyCreateAlarmResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDeleteAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDeleteAlarmResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmHistoryRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmHistoryResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsPartitionsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsPartitionsResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsResult;
import com.nifty.cloud.sdk.alarm.model.NiftyUpdateAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyUpdateAlarmResult;

/**
 * NIFCLOUD API 非同期クライアント インタフェース。 基本監視カテゴリクライアント。<br />
 * 基本監視カテゴリの非同期クライアントのインタフェースです。
 */
public interface NiftyAlarmAsync extends NiftyAlarm {

    /**
     * 非同期で基本監視ルールを新規作成します。
     *
     * @param request
     *            NiftyCreateAlarmResultリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyCreateAlarmResult>
        niftyCreateAlarmAsync(NiftyCreateAlarmRequest request);

    /**
     * 非同期で指定した基本監視ルールの情報を取得します。
     *
     * @param request
     *            NiftyDescribeAlarmsリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeAlarmsResult>
        niftyDescribeAlarmsAsync(NiftyDescribeAlarmsRequest request);

    /**
     * 非同期で基本監視ルールを更新します。
     * 
     * @param request
     *            NiftyUpdateAlarmリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyUpdateAlarmResult>
        niftyUpdateAlarmAsync(NiftyUpdateAlarmRequest request);

    /**
     * 非同期で基本監視ルールを削除します。
     * 
     * @param request
     *            NiftyDeleteAlarmリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDeleteAlarmResult>
        niftyDeleteAlarmAsync(NiftyDeleteAlarmRequest request);

    /**
     * 非同期で監視ルールに設定されているパーティション情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmsPartitionsリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeAlarmsPartitionsResult>
        niftyDescribeAlarmsPartitionsAsync(NiftyDescribeAlarmsPartitionsRequest request);

    /**
     * 非同期でアラーム履歴一覧を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmHistoryリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeAlarmHistoryResult>
        niftyDescribeAlarmHistoryAsync(NiftyDescribeAlarmHistoryRequest request);

    /**
     * 非同期で監視ルールの監視項目毎に、リソース異常発生と解除のログ情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmRulesActivitiesリクエスト
     * @return 非同期処理結果
     */
    public Future<NiftyDescribeAlarmRulesActivitiesResult>
        niftyDescribeAlarmRulesActivitiesAsync(NiftyDescribeAlarmRulesActivitiesRequest request);
}
