/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk.alarm;

import com.nifty.cloud.sdk.alarm.model.NiftyCreateAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyCreateAlarmResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDeleteAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDeleteAlarmResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmHistoryRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmHistoryResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmRulesActivitiesResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsPartitionsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsPartitionsResult;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyDescribeAlarmsResult;
import com.nifty.cloud.sdk.alarm.model.NiftyUpdateAlarmRequest;
import com.nifty.cloud.sdk.alarm.model.NiftyUpdateAlarmResult;

/**
 * NIFCLOUD API クライアント インタフェース。基本監視カテゴリ クライアント。<br />
 * 基本監視カテゴリの同期クライアントのインタフェースです。<br />
 * 戻り値の"利用不可"パラメータは返却値がnullまたは空となります。
 */
public interface NiftyAlarm {

    /**
     * エンドポイントの設定を行います。
     *
     * @param endpoint
     *            エンドポイント
     */
    public void setEndpoint(String endpoint);

    /**
     * 基本監視ルールを新規作成します。
     *
     * @param request
     *            NiftyCreateAlarmリクエスト
     * @return NiftyCreateAlarm処理結果
     */
    public NiftyCreateAlarmResult niftyCreateAlarm(NiftyCreateAlarmRequest request);

    /**
     * 指定した基本監視ルールの情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmsリクエスト<br />
     * @return NiftyDescribeAlarms処理結果
     */
    public NiftyDescribeAlarmsResult niftyDescribeAlarms(NiftyDescribeAlarmsRequest request);

    /**
     * 基本監視ルールを更新します。
     * 
     * @param request
     *            NiftyUpdateAlarmリクエスト<br />
     * @return NiftyUpdateAlarm処理結果
     */
    public NiftyUpdateAlarmResult niftyUpdateAlarm(NiftyUpdateAlarmRequest request);

    /**
     * 基本監視ルールを削除します。
     * 
     * @param request
     *            NiftyDeleteAlarmリクエスト<br />
     * @return NiftyDeleteAlarm処理結果
     */
    public NiftyDeleteAlarmResult niftyDeleteAlarm(NiftyDeleteAlarmRequest request);

    /**
     * 監視ルールに設定されているパーティション情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmsPartitionsリクエスト<br />
     * @return NiftyDescribeAlarmsPartitions処理結果
     */
    public NiftyDescribeAlarmsPartitionsResult
        niftyDescribeAlarmsPartitions(NiftyDescribeAlarmsPartitionsRequest request);

    /**
     * アラーム履歴一覧を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmHistoryリクエスト<br />
     * @return NiftyDescribeAlarmHistory処理結果
     */
    public NiftyDescribeAlarmHistoryResult
        niftyDescribeAlarmHistory(NiftyDescribeAlarmHistoryRequest request);

    /**
     * 監視ルールの監視項目毎に、リソース異常発生と解除のログ情報を取得します。
     * 
     * @param request
     *            NiftyDescribeAlarmRulesActivitiesリクエスト<br />
     * @return NiftyDescribeAlarmRulesActivities処理結果
     */
    public NiftyDescribeAlarmRulesActivitiesResult
        niftyDescribeAlarmRulesActivities(NiftyDescribeAlarmRulesActivitiesRequest request);

}
