/**
 * ******************************************************************************
 *  Copyright Fujitsu.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  You may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * *****************************************************************************
 *
 *  NIFCLOUD SDK for Java
 *
 */
package com.nifty.cloud.sdk;


/**
 * 定数定義インタフェース。<br />
 * 定数定義を格納するインタフェースです。
 *
 */
public interface Const {

	/** SDKプロパティファイル */
	public final static String PROPERTIES_FILE = "nifty_cloud-sdk";

	/** ユーザーエージェント	*/
	public static final String DEFAULT_USER_AGENT = "NIFCLOUD API Java SDK";

	/** プロトコル:HTTP */
	public final static String PROTOCOL_HTTP = "http";
	/** プロトコル:HTTPS */
	public final static String PROTOCOL_HTTPS = "https";

	/** デフォルトプロトコル	*/
	public final static String DEFAULT_PROTOCOL = PROTOCOL_HTTPS;

	/** NIFCLOUD API エンドポイント	*/
	public final static String DEFAULT_END_POINT = "https://jp-east-1.computing.api.nifcloud.com/api/";

	/** NIFCLOUD アップロード エンドポイント	*/
	public final static String DEFAULT_UPLOAD_END_POINT = "https://jp-east-1.vmupload.computing.api.nifcloud.com/VmUpload/vmupload";

	 /** デフォルト リトライ回数	*/
	public final static int MAX_ERROR_RETRY = 3;

	/** デフォルト 最大接続数 */
	public final static int MAX_CONNECTIONS = 50;

	/** デフォルト　SOタイムアウト秒数 */
	public final static int SOCKET_TIMEOUT = 300;

	/** デフォルト　接続タイムアウト秒数 */
	public final static int CONNECTION_TIMEOUT = 300;

	/** APIバージョン	*/
	public final static String VERSION_1_19 = "1.19";
	/** APIバージョン	*/
	public final static String VERSION_1_20 = "1.20";
	/** APIバージョン	*/
	public final static String VERSION_2_1 = "2.1";
	/** APIバージョン	*/
	public final static String VERSION_2_2 = "2.2";


	/** APIバージョン	*/
	public final static String VERSION = VERSION_2_2;



	/** SignatureVersion: バージョン0 */
	public final static String SIGNATURE_VERSION_0 = "0";
	/** SignatureVersion: バージョン1 */
	public final static String SIGNATURE_VERSION_1 = "1";
	/** SignatureVersion: バージョン2 */
	public final static String SIGNATURE_VERSION_2 = "2";

	/** デフォルト SignatureVersion	*/
	public final static String DEFAULT_SIGNATURE_VERSION = SIGNATURE_VERSION_2;

	/** SignatureMethod: HmacsSHA1 */
	public final static String SIGNATUTE_METHOD_HMAC_SHA1   = "HmacSHA1";
	/** SignatureMethod: HmacsSHA256 */
	public final static String SIGNATUTE_METHOD_HMAC_SHA256 = "HmacSHA256";

	/** デフォルト SignatureMethod	*/
	public final static String DEFAULT_SIGNATUTE_METHOD = SIGNATUTE_METHOD_HMAC_SHA256;

	/** HTTPメソッド: GET */
	public final static String HTTP_METHOD_GET = "GET";

	/** HTTPメソッド: POST */
	public final static String HTTP_METHOD_POST = "POST";

	public final static String HTTP_VERB = HTTP_METHOD_POST;

	/** エンコーディング	*/
	public final static String ENCODING = "UTF-8";

	/** アップロードブロックサイズデフォルト値(MB) */
	public final static int DEFAULT_UPLOAD_BLOCKSIZE = 8;
}
