/*
 * Decompiled with CFR 0.152.
 */
package com.nifty.cloud.sdk.vpngateway.model.transform;

import com.nifty.cloud.sdk.tools.DateUtils;
import com.nifty.cloud.sdk.vpngateway.model.BackupInformation;
import com.nifty.cloud.sdk.vpngateway.model.VersionInformation;
import com.nifty.cloud.sdk.vpngateway.model.VpnGateway;
import com.nifty.cloud.sdk.vpngateway.model.transform.AttachmentsConverter;
import com.nifty.cloud.sdk.vpngateway.model.transform.BackupInformationConverter;
import com.nifty.cloud.sdk.vpngateway.model.transform.GroupSetConverter;
import com.nifty.cloud.sdk.vpngateway.model.transform.NetworkInterfaceSetConverter;
import com.nifty.cloud.sdk.vpngateway.model.transform.TagSetConverter;
import com.nifty.cloud.sdk.vpngateway.model.transform.VersionInformationConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class VpnGatewaySetConverter
implements Converter {
    private static final String ELEMENT_VPN_GATEWAY_ID = "vpnGatewayId";
    private static final String ELEMENT_NIFTY_VPN_GATEWAY_NAME = "niftyVpnGatewayName";
    private static final String ELEMENT_STATE = "state";
    private static final String ELEMENT_TYPE = "type";
    private static final String ELEMENT_AVAILABILITY_ZONE = "availabilityZone";
    private static final String ELEMENT_ATTACHMENTS = "attachments";
    private static final String ELEMENT_TAG_SET = "tagSet";
    private static final String ELEMENT_NIFTY_VPN_GATEWAY_TYPE = "niftyVpnGatewayType";
    private static final String ELEMENT_NIFTY_REDUNDANCY = "niftyRedundancy";
    private static final String ELEMENT_NIFTY_VPN_GATEWAY_DESCRIPTION = "niftyVpnGatewayDescription";
    private static final String ELEMENT_ACCOUNTING_TYPE = "accountingType";
    private static final String ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE = "nextMonthAccountingType";
    private static final String ELEMENT_VERSION_INFORMATION = "versionInformation";
    private static final String ELEMENT_NETWORK_INTERFACE_SET = "networkInterfaceSet";
    private static final String ELEMENT_BACKUP_INFORMATION = "backupInformation";
    private static final String ELEMENT_GROUP_SET = "groupSet";
    private static final String ELEMENT_ROUTE_TABLE_ID = "routeTableId";
    private static final String ELEMENT_ROUTE_TABLE_ASSOCIATION_ID = "routeTableAssociationId";
    private static final String ELEMENT_CREATED_TIME = "createdTime";

    public boolean canConvert(Class clazz) {
        Class<?>[] interfaces;
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            if (i != List.class) continue;
            return true;
        }
        return false;
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<VpnGateway> vpnGateways = new ArrayList<VpnGateway>();
        AttachmentsConverter attachmentsConverter = new AttachmentsConverter();
        TagSetConverter tagSetConverter = new TagSetConverter();
        VersionInformationConverter versionInformationConverter = new VersionInformationConverter();
        NetworkInterfaceSetConverter networkInterfaceSetConverter = new NetworkInterfaceSetConverter();
        BackupInformationConverter backupInformationConverter = new BackupInformationConverter();
        GroupSetConverter groupSetConverter = new GroupSetConverter();
        String name = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            VpnGateway vpnGateway = new VpnGateway();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                name = reader.getNodeName();
                if (name.equals(ELEMENT_VPN_GATEWAY_ID)) {
                    vpnGateway.setVpnGatewayId(reader.getValue());
                } else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_NAME)) {
                    vpnGateway.setNiftyVpnGatewayName(reader.getValue());
                } else if (name.equals(ELEMENT_STATE)) {
                    vpnGateway.setState(reader.getValue());
                } else if (name.equals(ELEMENT_TYPE)) {
                    vpnGateway.setType(reader.getValue());
                } else if (name.equals(ELEMENT_AVAILABILITY_ZONE)) {
                    vpnGateway.setAvailabilityZone(reader.getValue());
                } else if (name.equals(ELEMENT_ATTACHMENTS)) {
                    vpnGateway.setAttachments((List)attachmentsConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_TAG_SET)) {
                    vpnGateway.setTagSet((List)tagSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_TYPE)) {
                    vpnGateway.setNiftyVpnGatewayType(reader.getValue());
                } else if (name.equals(ELEMENT_NIFTY_REDUNDANCY)) {
                    vpnGateway.setNiftyRedundancy(Boolean.valueOf(reader.getValue()));
                } else if (name.equals(ELEMENT_NIFTY_VPN_GATEWAY_DESCRIPTION)) {
                    vpnGateway.setNiftyVpnGatewayDescription(reader.getValue());
                } else if (name.equals(ELEMENT_ACCOUNTING_TYPE)) {
                    vpnGateway.setAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_NEXT_MONTH_ACCOUNTING_TYPE)) {
                    vpnGateway.setNextMonthAccountingType(reader.getValue());
                } else if (name.equals(ELEMENT_VERSION_INFORMATION)) {
                    vpnGateway.setVersionInformation((VersionInformation)versionInformationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_NETWORK_INTERFACE_SET)) {
                    vpnGateway.setNetworkInterfaces((List)networkInterfaceSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_BACKUP_INFORMATION)) {
                    vpnGateway.setBackupInformation((BackupInformation)backupInformationConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_GROUP_SET)) {
                    vpnGateway.setGroupIds((List)groupSetConverter.unmarshal(reader, context));
                } else if (name.equals(ELEMENT_ROUTE_TABLE_ID)) {
                    vpnGateway.setRouteTableId(reader.getValue());
                } else if (name.equals(ELEMENT_ROUTE_TABLE_ASSOCIATION_ID)) {
                    vpnGateway.setRouteTableAssociationId(reader.getValue());
                } else if (name.equals(ELEMENT_CREATED_TIME)) {
                    vpnGateway.setCreatedTime(DateUtils.toDate(reader.getValue()));
                }
                reader.moveUp();
            }
            vpnGateways.add(vpnGateway);
            reader.moveUp();
        }
        return vpnGateways;
    }

    public void marshal(Object paramObject, HierarchicalStreamWriter paramHierarchicalStreamWriter, MarshallingContext paramMarshallingContext) {
    }
}

